pro mockdata,pearl=pearl,poisson=poisson,model=model,triple=triple,init=init
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Replace observed visibilities and triple data with model values.
; Also includes photometry. Calls set_complexweight to set complex weights.
; Model values must have been computed before (except for option pearl).
;
; Options for model data, visibility data...
; pearl:   from pearl visibility data, given matching SysConfig and scans
; poisson: from model values, errors replaced with Poisson noise estimates
; else:    from model values, errors unchanged
;
; If model=1, use model to compute model values (only for poisson=1)
; If triple=1, set_complexweight will drop loose baselines
; If init=1, set all model visibilities to 1
;
common StarBase,startable,notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common Tables,ScanTable,BGTable,StationTable
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
;
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
common PearlBaselines,ob_index,bl_index
common LocalPearl,star,pearl_channel
;
if n_elements(pearl) eq 0 then pearl=0
if n_elements(poisson) eq 0 then poisson=0
if n_elements(model) eq 0 then model=0
;
; Option "triple" used in call to set_complexweight
if n_elements(triple) eq 0 then triple=1
;
; Option "init" sets all model visibilities to unity
if n_elements(init) eq 0 then init=0
;
if pearl and n_elements(geninfo.date) gt 1 then begin
	print,'Error: pearl option cannot be used for multiple nights!'
	return
endif
;
for i=0,n_elements(geninfo.date)-1 do begin
;
if n_elements(bufferinfo) gt 1 then $
loadnight,geninfo[i].date,geoinfo[i].systemid,geninfo[i].configid
;
if checkdata([8,9]) ne 0 then return
;
IF pearl gt 0 THEN BEGIN
;
; This option produces absolute visibility phases, VisPhase
phase_rms=pearl	; VisPhaseErr initialized with phase RMS
;
index0=where(scans.starid eq star and scantable.code eq 1,NS0)
if NS0 lt max(unique(si)) then begin
	print,'Error(MOCKDATA): inconsistency between data structures!'
	return
endif
; Check if "triple" option was used in set_complexweight
index=where(scans[index0].vissqcerr gt 0,count_v)
index=where(scans[index0].complexweight ne 0,count_w)
if count_w lt count_v then scans[index0].vissqcerr=-abs(scans[index0].vissqcerr)
;
w=total(genconfig.wavelength,2)/genconfig.numoutbeam & w=w*1e9
indexj=whereequal(w,wl)
stationids=genconfig.stationid
for ob=0,genconfig.numoutbeam-1 do begin
for bl=0,genconfig.numbaseline[ob]-1 do begin
;	e=reform(scans(*).vissqcerr(ob,0:GenConfig.NumSpecChan(ob)-1,bl) > 0)
;	if GenConfig.NumSpecChan(ob) gt 1 then e=total(e,1)
;	index=where(scans.starid eq star and scantable.code eq 1 and e gt 0,NS)
 	index=index0
 	ns=ns0
	if NS gt 0 then begin
        m=where(stationids eq strmid(genconfig.baselineid[bl,ob],0,3))+1
        n=where(stationids eq strmid(genconfig.baselineid[bl,ob],4,3))+1
        id=100*m+n & id=id[0]
	for ch=0,genconfig.numspecchan[ob]-1 do begin
	for sc=0,NS-1 do begin
		jndex=where(bi eq id and indexj[ci-1] eq ch $
				     and si-1 eq sc,count)
		for k=0,count-1 do begin
			obi=ob_index[jndex[k]]
			bli=bl_index[jndex[k]]
			scans[index[sc]].complexvis(obi,ch,bli)=cv[jndex[k]]
			scans[index[sc]].visphase(obi,ch,bli)=cphase(cv[jndex[k]])
			scans[index[sc]].visphaseerr(obi,ch,bli)=phase_rms
			scans[index[sc]].vissqc(obi,ch,bli)=abs(cv[jndex[k]])^2
 			scans[index[sc]].vissqcerr(obi,ch,bli)= $
 			abs(scans[index[sc]].vissqcerr(obi,ch,bli))
		endfor
		if 0 then begin	; obsolete
		if count eq genconfig.numoutbeam then begin
			scans[index[sc]].complexvis(ob,ch,bl)=cv[jndex[ob]]
			scans[index[sc]].vissqc(ob,ch,bl)=abs(cv[jndex[ob]])^2
 			scans[index[sc]].vissqcerr(ob,ch,bl)= $
 			abs(scans[index[sc]].vissqcerr(ob,ch,bl))
		endif else if count eq 1 then begin
			scans[index[sc]].complexvis(ob,ch,bl)=cv[jndex]
			scans[index[sc]].vissqc(ob,ch,bl)=abs(cv[jndex])^2
 			scans[index[sc]].vissqcerr(ob,ch,bl)= $
 			abs(scans[index[sc]].vissqcerr(ob,ch,bl))
		endif
		endif
	endfor
	endfor
	endif 	; NS > 0
endfor
endfor
;
scans.tripleampcerr=-abs(scans.tripleampcerr)
scans.triplephasecerr=-abs(scans.triplephasecerr)
;
for tr=0,GenConfig.NumTriple-1 do begin
	nc=GenConfig.TripleNumChan[tr]
;
;	e=reform(scans(*).tripleampcerr(tr,0:GenConfig.TripleNumChan(tr)-1) > 0)
;	if GenConfig.TripleNumChan(tr) gt 1 then e=total(e,1)
;	index=where(scans.starid eq star and scantable.code eq 1 and e gt 0,NS)
 	index=index0
 	ns=ns0
	if NS gt 0 then begin
 	vis=reform(complexarr(3,nc,NS,/nozero),3,nc,NS)
 	err=reform(fltarr(3,nc,NS,/nozero),3,nc,NS)
	fBaseMatrix=intarr(GenConfig.NumSid,3)
	fBaseFactor=fltarr(3)+1
	for l=0,2 do begin
		ob=GenConfig.TripleBeam[l,tr]
		bl=GenConfig.TripleBase[l,tr]
		j1=where(GenConfig.StationId eq $
		  strmid(GenConfig.BaselineId[bl,ob],0,3))
		j2=where(GenConfig.StationId eq $
		  strmid(GenConfig.BaselineId[bl,ob],4,3))
		fBaseMatrix[j1,l]=+1
		fBaseMatrix[j2,l]=-1
		if l gt 0 then $
			fBaseFactor[l]=-total(fBaseMatrix[*,0]*fBaseMatrix[*,l])
	endfor
	for l=0,2 do begin
		ob=GenConfig.TripleBeam[l,tr]
		bl=GenConfig.TripleBase[l,tr]
		ch=GenConfig.TripleChan[0:GenConfig.TripleNumChan[tr]-1,l,tr]
		for j=0,nc-1 do begin
			vis[l,j,*]=scans[index].complexvis(ob,ch[j],bl)
			err[l,j,*]=scans[index].vissqcerr(ob,ch[j],bl)
		endfor
		if fBaseFactor[l] lt 0 then vis[l,*,*]=conj(vis[l,*,*])
	endfor
;
;	Form complex triple products
	result=reform(float(vis[0,*,*]*vis[1,*,*]*vis[2,*,*]),1,1,nc,NS)
	if nc eq 1 then result=reform(result,1,NS)
	if nc eq 1 and NS eq 1 then result=reform(result)
	scans[index].compltriple(tr,0,0:nc-1)=result
	result=reform(imaginary(vis[0,*,*]*vis[1,*,*]*vis[2,*,*]),1,1,nc,NS)
	if nc eq 1 then result=reform(result,1,NS)
	if nc eq 1 and NS eq 1 then result=reform(result)
	scans[index].compltriple(tr,1,0:nc-1)=result
;
;	Form complex triple error mask
	compltripleerr=reform(float( $
	(err[0,*,*] gt 0)*(err[1,*,*] gt 0)*(err[2,*,*] gt 0)),1,1,nc,NS)
	if nc eq 1 then result=reform(compltripleerr,1,NS)
	if nc eq 1 and NS eq 1 then result=reform(compltripleerr)
;
;	Compute amp and phase
	result=reform(sqrt(scans[index].compltriple(tr,0,0:nc-1)^2 $
			  +scans[index].compltriple(tr,1,0:nc-1)^2),1,nc,NS)
	if nc eq 1 then result=reform(result,1,NS)
	if nc eq 1 and NS eq 1 then result=reform(result)
	scans[index].tripleampc(tr,0:nc-1)=result
	compltripleerr=reform(compltripleerr,size(result,/dim))*2-1
 	scans[index].tripleampcerr(tr,0:nc-1)= $
 	abs(scans[index].tripleampcerr(tr,0:nc-1))*compltripleerr
	result=reform(atan(scans[index].compltriple(tr,1,0:nc-1), $
			   scans[index].compltriple(tr,0,0:nc-1)),1,nc,NS)
	if nc eq 1 then result=reform(result,1,NS)
	if nc eq 1 and NS eq 1 then result=reform(result)
	scans[index].triplephasec(tr,0:nc-1)= result
 	scans[index].triplephasecerr(tr,0:nc-1)= $
 	abs(scans[index].triplephasecerr(tr,0:nc-1))*compltripleerr
;
	endif ; NS > 1
;
endfor
;
ENDIF ELSE IF poisson gt 0 THEN BEGIN
;
if init then begin
	scans.vissqm=1
	scans.tripleampm=1
	scans.triplephasem=0
endif
;
if model ne 0 then begin
	index=where(scans.starid eq gen_model.starid)
	scans[index].vissqcerr=0.1
	scans[index].tripleampcerr=0.1
	scans[index].triplephasecerr=0.1
	calcmodel,/noload
endif else index=indgen(n_elements(scans))
scans[index].photonrate=poisson
scans[index].vissqcerr=-1
scans[index].tripleampcerr=-1
scans[index].triplephasecerr=-1
genconfig.numbin=8
nframe=5000
a=fltarr(nframe)
g=a
;
for n=0,n_elements(index)-1 do begin
for t=0,genconfig.numtriple-1 do begin
	ob1=genconfig.triplebeam[0,t]
	ob2=genconfig.triplebeam[1,t]
	ob3=genconfig.triplebeam[2,t]
	bl1=genconfig.triplebase[0,t]
	bl2=genconfig.triplebase[1,t]
	bl3=genconfig.triplebase[2,t]
;
       	fBaseMatrix=intarr(GenConfig.NumSid,3)
       	fBaseFactor=fltarr(3)+1
       	for l=0,2 do begin
               	ob=GenConfig.TripleBeam[l,t]
               	bl=GenConfig.TripleBase[l,t]
               	j1=where(GenConfig.StationId eq $
		  strmid(GenConfig.BaselineId[bl,ob],0,3))
               	j2=where(GenConfig.StationId eq $
		  strmid(GenConfig.BaselineId[bl,ob],4,3))
               	fBaseMatrix[j1,l]=+1
               	fBaseMatrix[j2,l]=-1
               	if l gt 0 then $
		fBaseFactor[l]=-total(fBaseMatrix[*,0]*fBaseMatrix[*,l])
       	endfor
for j=0,genconfig.triplenumchan[t]-1 do begin
	b1=fringeframe(a,g,genconfig.wavelength[j,ob1]*1e6, $
		sqrt(scans[index[n]].vissqm(ob1,j,bl1)), $
		scans[index[n]].photonrate(ob1,j),/poisson, $
		phase=scans[index[n]].visphasem(ob1,j,bl1))
	b2=fringeframe(a,g,genconfig.wavelength[j,ob2]*1e6, $
		sqrt(scans[index[n]].vissqm(ob2,j,bl2)), $
		scans[index[n]].photonrate(ob2,j),/poisson, $
		phase=scans[index[n]].visphasem(ob2,j,bl2))
	b3=fringeframe(a,g,genconfig.wavelength[j,ob3]*1e6, $
		sqrt(scans[index[n]].vissqm(ob3,j,bl3)), $
		scans[index[n]].photonrate(ob3,j),/poisson, $
		phase=scans[index[n]].visphasem(ob3,j,bl3))
	v2=fringevissq(b1,1,200,error=v2e,/normal,/bin8)
	v2m=wmean(v2,v2e,v2me)
	scans[index[n]].vissqc(ob1,j,bl1)=v2m
	scans[index[n]].vissqcerr(ob1,j,bl1)=v2me
	v2=fringevissq(b2,1,200,error=v2e,/normal,/bin8)
	v2m=wmean(v2,v2e,v2me)
	scans[index[n]].vissqc(ob2,j,bl2)=v2m
	scans[index[n]].vissqcerr(ob2,j,bl2)=v2me
	v2=fringevissq(b3,1,200,error=v2e,/normal,/bin8)
	v2m=wmean(v2,v2e,v2me)
	scans[index[n]].vissqc(ob3,j,bl3)=v2m
	scans[index[n]].vissqcerr(ob3,j,bl3)=v2me
;
	v1=fringevis(b1)*(sqrt(4.0/sinc(1./8)^2)/avg(fringenphot(b1)))
	if fBaseFactor[0] lt 0 then v1=conj(v1)
	v2=fringevis(b2)*(sqrt(4.0/sinc(1./8)^2)/avg(fringenphot(b1)))
	if fBaseFactor[1] lt 0 then v2=conj(v2)
	v3=fringevis(b3)*(sqrt(4.0/sinc(1./8)^2)/avg(fringenphot(b1)))
	if fBaseFactor[2] lt 0 then v3=conj(v3)
	vt=v1*v2*v3
	vtm=total(vt)/nframe
;
	vtre=stddev(float(vt))/sqrt(nframe)
	vtie=stddev(imaginary(vt))/sqrt(nframe)
;
	scans[index[n]].tripleampc(t,j)=abs(vtm)
	scans[index[n]].tripleampcerr(t,j)=sqrt(vtre^2+vtie^2)
	scans[index[n]].triplephasec(t,j)=cphase(vtm)
	scans[index[n]].triplephasecerr(t,j)=sqrt(vtre^2+vtie^2)/abs(vtm)
endfor
endfor
endfor
;
scans[index].photometry=scans[index].photometrym
set_complexweight,triple=triple
;
ENDIF ELSE BEGIN
;
if init then begin
	scans.vissqm=1
	scans.tripleampm=1
	scans.triplephasem=0
endif
;
scans.vissq=scans.vissqm
scans.vissqc=scans.vissqm		; This is the only important quantity
scans.vissqe=scans.vissqm
scans.vissqec=scans.vissqm
scans.tripleamp=scans.tripleampm
scans.tripleampc=scans.tripleampm	; This is the only important quantity
scans.tripleampe=scans.tripleampm
scans.tripleampec=scans.tripleampm
scans.triplephasec=scans.triplephasem	; This is the only important quantity
;
scans.photometry=scans.photometrym
set_complexweight,triple=triple
;
ENDELSE
;
if n_elements(bufferinfo) gt 1 then $
storenight,11
;
endfor
;
end
