function modeldm,component,filter_in
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute broad band filter magnitude differences given a physical model.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
; Filter should be one of UBVRI, or full function name as in filter.pro
if strlen(filter_in) eq 1 then filter_in=strupcase(filter_in)
;
teff1=star_model[0].teff
teff2=star_model[1].teff
logg1=star_model[0].logg
logg2=star_model[1].logg
d1=star_model[0].diameter
d2=star_model[1].diameter
;
case filter_in of
	'U':filter='johnson_u'
	'B':filter='johnson_b'
	'V':filter='johnson_v'
	'R':filter='johnson_r'
	'I':filter='johnson_i'
	'J':filter='johnson_j'
	'K':filter='johnson_k'
endcase
;
; Primary A
r=limbgrid(teff1,logg1,lamda,limbdu,fluxes)
f1=total(call_function(filter,lamda)*fluxes) $
    /total(call_function(filter,lamda))
;
; Secondary B
r=limbgrid(teff2,logg2,lamda,limbdu,fluxes)
f2=total(call_function(filter,lamda)*fluxes) $
    /total(call_function(filter,lamda))
;
; Radii
r1=d1/2
r2=d2/2
;
; Magnitudes
mag1=-2.5*alog10(f1*r1^2)
mag2=-2.5*alog10(f2*r2^2)
;
; Return predicted A-B magnitude differences
return,mag2-mag1
;
end
