function modelf,component
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute and return mass function.
; Return -1 if failed for any reason.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common AstroConstants,m_sun,r_sun,a_unit,s_year
;
RAD=180/pi_circle
;
if componentparse(strupcase(component),comp_1,comp_2) ne 0 then return,-1
i=where(binary_model.component eq strupcase(component)) & i=i[0]
masses=componentmass(comp_1,comp_2)
m1=masses[0]
m2=masses[1]
i=binary_model[i].inclination/RAD
;
fm=(m2^3*sin(i)^3)/(m1+m2)^2
;
return,fm
;
end
