function modelflux,epochs,lamda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Computes total fluxes for a multiple star model.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if num_binary() gt 0 then begin
; 	Find the toplevel component
	levels=strlen(binary_model.component)
	index=where(max(levels) eq levels)
	modflux=componentflux(binary_model[index].component,epochs,lamda)
endif else if num_star() ge 1 then begin
	num_scan=n_elements(epochs)
	num_wave=n_elements(lamda)
	modflux=dblarr(num_wave,num_scan)
	for i=0,num_star()-1 do begin
	modflux= $
	modflux+componentflux(star_model[i].component,epochs,lamda)
	endfor
endif else begin
	print,'***Error(MODELFLUX): model incomplete!'
	return,-1
endelse
;
return,modflux
end
