function modelfluxes,model,lamda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute the flux scaling factor based on the magnitude of a component.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
; Corrections with magnitudes
if n_elements(gen_model.wavelengths) eq 1 then begin
	c1=lamda*0+mag2flux(model.magnitudes)
	c1=c1[0]
endif else if n_elements(gen_model.wavelengths) eq 2 then begin
	c1=mag2flux(polynom(lamda*1d6, $
			polyfit(gen_model.wavelengths,model.magnitudes,1)))
;print,'----------------------------'
;print,'Lambda',lamda*1e6,'Magnitudes:',model.magnitudes,'Flux',c1
;if n_elements(lamda) gt 2 then stop
endif else begin
	c1=mag2flux(spline(gen_model.wavelengths,model.magnitudes,lamda*1d6))
endelse
;
return,c1
;
end
