function modelk,component
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute and return velocity semi-amplitude of requested stellar component.
; Note that for systems of three or more components, the amplitude is in
; rest frame of the corresponding binary component.
; Return -1 if failed for any reason.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common AstroConstants,m_sun,r_sun,a_unit,s_year
;
RAD=180/pi_circle
;
if n_elements(binary_model) eq 0 then return,-1
pos=strpos(binary_model.component,strupcase(component))
index=where(pos ge 0,count)
if count eq 0 then return,-1
models=binary_model[index]
model=models[where(strlen(binary_model.component) eq $
	       min(strlen(binary_model.component)))]
model=model[0]
pos=strpos(model.component,strupcase(component))
if componentparse(model.component,comp_1,comp_2) ne 0 then return,-1
masses=componentmass(comp_1,comp_2)
m1=masses[0]
m2=masses[1]
i=model.inclination/RAD
e=model.eccentricity
p=model.period/s_year
k1=2*pi_circle*sin(i)/sqrt(1-e^2)*p^(-1.0/3.0)*m2*(m1+m2)^(-2.0/3.0) $
	*(a_unit/s_year)/86400000L
k2=k1*(m1/m2)
;
if pos eq 0 then return,k1 else return,k2
;
end
