function modellogg,component
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given a binary_component, compute for all single-star sub-components
; the luminosity using Stefan-Boltzmann law from radius and eff. temperature.
; Must have read physical binary model before (Teff, diameter, masses, etc.).
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if n_elements(component) eq 0 then component=topbincomp()
if modelparse(component,comp_1,comp_2) eq -1 then return,-1
components=[comp_1,comp_2]
index=where(strlen(components) eq 1,n_comp)
components=components[index]
logg=fltarr(n_comp)
;
px=modelpx(component)
mas_to_rsun=(215./2)/px ; to convert angular diameters to radii in solar units
;
for i=0,n_comp-1 do begin
	k=where(star_model.component eq components[i])
	logg[i]=logg_mass[star_model[k].mass,star_model[k].diameter*mas_to_rsun]
endfor
;
return,logg
;
end
