function modellum,component
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given a binary_component, compute for all single-star sub-components
; the luminosity using Stefan-Boltzmann law from radius and eff. temperature.
; Must have read physical binary model before (Teff, diameter, masses, etc.).
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if n_elements(component) eq 0 then component=topbincomp()
if modelparse(component,comp_1,comp_2) eq -1 then return,-1
components=[comp_1,comp_2]
index=where(strlen(components) eq 1,n_comp)
components=components[index]
lum=fltarr(n_comp)
;
px=modelpx(component)
dm=5*alog10(1./(px/1000))-5
mas_to_rsun=(215./2)/px ; to convert angular diameters to radii in solar units
;
for i=0,n_comp-1 do begin
	k=where(star_model.component eq components[i])
	lum[i]=lum_teff[star_model[k].teff,star_model[k].diameter*mas_to_rsun]
	mv=4.74-2.5*alog10(lum[i])-bc_teff[star_model[k].teff]+dm
	if i eq 0 then tmv=mv else tmv=cmag(tmv,mv)
endfor
;
; Make sure total luminosity is normalized to observed (total) V magnitude
j=where(abs(gen_model.wavelengths-0.55) lt 0.02,count)
if count eq 0 then begin
	print,'Error: model lacks visual magnitude!'
	return,-1
endif
f=10^(-(star_model[0].magnitudes(j[0])-tmv)/2.5)
;
return,lum*f
;
end
