function modelm,component,error
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute total mass of a binary component with Kepler's 3rd law with parallax.
; Also provides an error estimate if parameter errors been computed before.
;
common AuxData,parallaxes,k1,k2,vsini
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
; if componentparse(strupcase(component),comp_1,comp_2) ne 0 then return,-1
; mass_sum=total(componentmass(comp_1,comp_2))
i=where(binary_model.component eq strupcase(component)) & i=i[0]
mass_sum=(binary_model[i].semimajoraxis/parallaxes.value[0])^3 $
	/(binary_model[i].period/365.25)^2
error=mass_sum*sqrt( $
	(3*binary_error[i].semimajoraxis/binary_model[i].semimajoraxis)^2+ $
       	(3*binary_error[i].period/binary_model[i].period)^2+ $
	(2*parallaxes.error[0]/parallaxes.value[0])^2)
return,mass_sum
;
end
