pro modelparmcopy,direction,a,da,init=init
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Copies parameters in array a from (direction=-1) and to (direction=1)
; hierarchical stellar model. Also initializes array da which contains
; increments for the parameters to be used in the differential corrections.
; Procedure determines for each parameter listing the component, whether
; it is a binary component or something else, i.e. either star or general
; model. Since the parameter names are currently unique, this is not really
; necessary for the division of the case statements into two sections.
;
; Some parameter safeguards are implemented (e.g. e<1,a>0)
;
; If init=1 (only when called by set_h_steps), initialize increments
; based on Chi^2 increase when varying the step size. To be combined with
; fit_options.h=1 which causes these results to be used during fitting.
; Note that in this case, the Chi^2 of the mock data is zero!
;
common MarquardtFit,fit_options
common ModelFit,parameters,ds_options
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if n_elements(init) eq 0 then init=0
;
maxparm=1000
if direction eq -1 then a=dblarr(maxparm)
da=a
chisq0=0.1	; target chisq increase for da with mock data
;
rad=180/!pi
;
n=0	; ID in flat parameter array
;
FOR j=0,n_elements(parameters)-1 DO BEGIN
;
if strlen(parameters[j].component) gt 0 then begin
;
binary=strpos(parameters[j].component,'-')
if binary gt 0 then begin
	ic=where(binary_model.component eq parameters[j].component) & ic=ic[0]
endif else begin
	ic=where(star_model.component eq parameters[j].component) & ic=ic[0]
endelse
index=where(strlen(parameters[j].names) gt 0,np)
for i=0,np-1 do begin
	parameter=parameters[j].names(i)
	if binary gt 0 then begin
	case parameter of
		'MassRatio': begin
			if direction eq 1 then $
				binary_model[ic].massratio=abs(a[n]) else $
				a[n]=binary_model[ic].massratio
			da[n]=0.01
			end
		'Semimajoraxis': begin
			if direction eq 1 then $
				binary_model[ic].semimajoraxis=abs(a[n]) else $
				a[n]=binary_model[ic].semimajoraxis
			da[n]=0.01	; mas
			da[n]=0.3	; mas
			if init then begin
				binary_model[ic].semimajoraxis= $
				binary_model[ic].semimajoraxis+da[n]
				calcmodel,/quiet
				binary_model[ic].semimajoraxis= $
				binary_model[ic].semimajoraxis-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				binary_error[ic].semimajoraxis= $
					sqrt(chisq0/(chisq/da[n]^2))
			endif else if fit_options.h $
				and binary_error[ic].semimajoraxis ne 0 then $
				da[n]=binary_error[ic].semimajoraxis
			end
		'Inclination': begin
			if direction eq 1 then $
				binary_model[ic].inclination=a[n] mod 360 else $
				a[n]=binary_model[ic].inclination
			da[n]=0.01	; deg
			da[n]=0.1/(sin(binary_model[ic].inclination/rad)+0.1)
			if init then begin
				binary_model[ic].inclination= $
				binary_model[ic].inclination+da[n]
				calcmodel,/quiet
				binary_model[ic].inclination= $
				binary_model[ic].inclination-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				binary_error[ic].inclination= $
					sqrt(chisq0/(chisq/da[n]^2)) < 1
			endif else if fit_options.h $
				and binary_error[ic].inclination ne 0 then $
				da[n]=binary_error[ic].inclination
			end
		'Ascendingnode': begin
			if direction eq 1 then $
				binary_model[ic].ascendingnode=a[n] mod 360 else $
				a[n]=binary_model[ic].ascendingnode
			da[n]=0.01/(sin(binary_model[ic].inclination)+0.001)
			da[n]=atan(0.3/(binary_model[ic].semimajoraxis>0.01))*rad
			if init then begin
				binary_model[ic].ascendingnode= $
				binary_model[ic].ascendingnode+da[n]
				calcmodel,/quiet
				binary_model[ic].ascendingnode= $
				binary_model[ic].ascendingnode-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				binary_error[ic].ascendingnode= $
					sqrt(chisq0/(chisq/da[n]^2))
			endif else if fit_options.h $
				and binary_error[ic].ascendingnode ne 0 then $
				da[n]=binary_error[ic].ascendingnode
			end
		'Eccentricity': begin
			if direction eq 1 then $
				binary_model[ic].eccentricity=a[n] < 0.99 else $
				a[n]=binary_model[ic].eccentricity
			da[n]=0.001
			if init then begin
				binary_model[ic].eccentricity= $
				binary_model[ic].eccentricity+da[n]
				calcmodel,/quiet
				binary_model[ic].eccentricity= $
				binary_model[ic].eccentricity-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				binary_error[ic].eccentricity= $
					sqrt(chisq0/(chisq/da[n]^2))
			endif else if fit_options.h $
				and binary_error[ic].eccentricity ne 0 then $
				da[n]=binary_error[ic].eccentricity
			end
		'Periastron': begin
			if direction eq 1 then $
				binary_model[ic].periastron=a[n] else $
				a[n]=binary_model[ic].periastron
			da[n]=0.01/(binary_model[ic].eccentricity^2+0.001)
			da[n]=sqrt(atan(0.3 $
				/(binary_model[ic].semimajoraxis>0.01))*rad)
			if init then begin
				binary_model[ic].periastron= $
				binary_model[ic].periastron+da[n]
				calcmodel,/quiet
				binary_model[ic].periastron= $
				binary_model[ic].periastron-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				binary_error[ic].periastron= $
					sqrt(chisq0/(chisq/da[n]^2))
			endif else if fit_options.h $
				and binary_error[ic].periastron ne 0 then $
				da[n]=binary_error[ic].periastron
			end
		'Apsidalmotion': begin
			if direction eq 1 then $
				binary_model[ic].apsidalmotion=a[n] else $
				a[n]=binary_model[ic].apsidalmotion
			da[n]=0.01/(binary_model[ic].eccentricity^2+0.001)
			if init then begin
				binary_model[ic].apsidalmotion= $
				binary_model[ic].apsidalmotion+da[n]
				calcmodel,/quiet
				binary_model[ic].apsidalmotion= $
				binary_model[ic].apsidalmotion-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				binary_error[ic].apsidalmotion= $
					sqrt(chisq0/(chisq/da[n]^2))
			endif else if fit_options.h $
				and binary_error[ic].apsidalmotion ne 0 then $
				da[n]=binary_error[ic].apsidalmotion
			end
		'Epoch': begin
			if direction eq 1 then $
				binary_model[ic].epoch=a[n] else $
				a[n]=binary_model[ic].epoch
			da[n]=binary_model[ic].period/1000
			if init then begin
				binary_model[ic].epoch= $
				binary_model[ic].epoch+da[n]
				calcmodel,/quiet
				binary_model[ic].epoch= $
				binary_model[ic].epoch-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				binary_error[ic].epoch= $
					sqrt(chisq0/(chisq/da[n]^2))
			endif else if fit_options.h $
				and binary_error[ic].epoch ne 0 then $
				da[n]=binary_error[ic].epoch
			end
		'Period': begin
			if direction eq 1 then $
				binary_model[ic].period=abs(a[n]) else $
				a[n]=binary_model[ic].period
			da[n]=binary_model[ic].period/10000
			da[n]=binary_model[ic].period/1000
			if init then begin
				binary_model[ic].period= $
				binary_model[ic].period+da[n]
				calcmodel,/quiet
				binary_model[ic].period= $
				binary_model[ic].period-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				binary_error[ic].period= $
					sqrt(chisq0/(chisq/da[n]^2))
			endif else if fit_options.h $
				and binary_error[ic].period ne 0 then $
				da[n]=binary_error[ic].period
			end
		'Rho': begin
			if direction eq 1 then $
				binary_model[ic].rho=abs(a[n]) else $
				a[n]=binary_model[ic].rho
			da[n]=0.1	; mas
			end
		'Theta': begin
			if direction eq 1 then $
				binary_model[ic].theta=a[n] mod 360 else $
				a[n]=binary_model[ic].theta
			da[n]=0.001
			if binary_model[ic].rho gt 0 then $
			da[n]=atan(0.1/binary_model[ic].rho)*rad
			end
	endcase
	endif else begin ; not binary component
	pos=strpos(parameters[j].names(i),'Magnitude')
	if pos ge 0 then begin
		wave=float(strmid(parameter,10,5))
		ch=where(string(gen_model.wavelengths,format='(f5.2)')  eq wave)
		parameter=strmid(parameter,0,9)
	endif
	case parameter of
		'RV':	begin
			if direction eq 1 then $
				gen_model.rv=a[n] else $
				a[n]=gen_model.rv
			da[n]=1.0
			if init then begin
				gen_model.rv= $
					gen_model.rv+da[n]
				calcmodel,/quiet
				gen_model.rv= $
					gen_model.rv-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				gen_error.rv= $
					sqrt(chisq0/(chisq/da[n]^2)) < da[n]
			endif else if fit_options.h $
				and gen_error.rv ne 0 then $
				da[n]=gen_error.rv
			end
		'Parallax': begin
			if direction eq 1 then $
				gen_model.px=a[n] else $
				a[n]=gen_model.px
			da[n]=0.005*gen_model.px
			end
		'SM': begin
			if direction eq 1 then $
				gen_model.sm=a[n] else $
				a[n]=gen_model.sm
			da[n]=0.05*gen_model.sm
			end
		'Mass':	begin
			if direction eq 1 then $
				star_model[ic].mass=a[n] else $
				a[n]=star_model[ic].mass
			da[n]=star_model[ic].mass/40
			if init then begin
				star_model[ic].mass= $
					star_model[ic].mass+da[n]
				calcmodel,/quiet
				star_model[ic].mass= $
					star_model[ic].mass-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				star_error[ic].mass= $
					sqrt(chisq0/(chisq/da[n]^2)) < da[n]
			endif else if fit_options.h $
				and star_error[ic].mass ne 0 then $
				da[n]=star_error[ic].mass
			end
		'Diameter': begin
			if direction eq 1 then $
				star_model[ic].diameter=abs(a[n]) else $
				a[n]=abs(star_model[ic].diameter)
			da[n]=0.1
			if star_model[ic].type eq 15 then da[n]=1
			if init then begin
				star_model[ic].diameter= $
					star_model[ic].diameter+da[n]
				calcmodel,/quiet
				star_model[ic].diameter= $
					star_model[ic].diameter-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				star_error[ic].diameter= $
					sqrt(chisq0/(chisq/da[n]^2))
			endif else if fit_options.h $
				and star_error[ic].diameter ne 0 then $
				da[n]=star_error[ic].diameter
			end
		'Width': begin
			if direction eq 1 then $
				star_model[ic].width=abs(a[n])>0.05 else $
				a[n]=star_model[ic].width
			da[n]=0.2
			if init then begin
				star_model[ic].width= $
					star_model[ic].width+da[n]
				calcmodel,/quiet
				star_model[ic].width= $
					star_model[ic].width-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				star_error[ic].width= $
					sqrt(chisq0/(chisq/da[n]^2))
			endif else if fit_options.h $
				and star_error[ic].width ne 0 then $
				da[n]=star_error[ic].width
			end
		'Ratio': begin
			if direction eq 1 then $
				star_model[ic].ratio=abs(a[n]) else $
				a[n]=abs(star_model[ic].ratio)
			if a[n] gt 1 then begin
				a[n]=1/a[n]
				star_model[ic].ratio=a[n]
				star_model[ic].pa=(star_model[ic].pa+90) mod 360
			endif
			da[n]=0.05
			if init then begin
				star_model[ic].ratio= $
					star_model[ic].ratio+da[n]
				if a[n] gt 1 then begin
					a[n]=1/a[n]
					star_model[ic].ratio=a[n]
					star_model[ic].pa $
						=(star_model[ic].pa+90) mod 360
				endif
				calcmodel,/quiet
				star_model[ic].ratio= $
					star_model[ic].ratio-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				star_error[ic].ratio= $
					sqrt(chisq0/(chisq/da[n]^2))
			endif else if fit_options.h $
				and star_error[ic].ratio ne 0 then $
				da[n]=star_error[ic].ratio
			end
		'PA': begin
			if direction eq 1 then $
				star_model[ic].pa=a[n] mod 360 else $
				a[n]=star_model[ic].pa mod 360
			da[n]=5.0
			if init then begin
				star_model[ic].pa= $
					star_model[ic].pa+da[n]
				calcmodel,/quiet
				star_model[ic].pa= $
					star_model[ic].pa-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				star_error[ic].pa= $
					sqrt(chisq0/(chisq/da[n]^2))
			endif else if fit_options.h $
				and star_error[ic].pa ne 0 then $
				da[n]=star_error[ic].pa
			end
		'Tilt': begin
			if direction eq 1 then $
				star_model[ic].tilt=a[n] else $
				a[n]=star_model[ic].tilt
			da[n]=5.0
			end
		'Teff': begin
			if direction eq 1 then $
				star_model[ic].teff=a[n] else $
				a[n]=star_model[ic].teff
			da[n]=100
			if init then begin
				star_model[ic].teff= $
					star_model[ic].teff+da[n]
				calcmodel,/quiet
				star_model[ic].teff= $
					star_model[ic].teff-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				star_error[ic].teff= $
					sqrt(chisq0/(chisq/da[n]^2))
			endif else if fit_options.h $
				and star_error[ic].teff ne 0 then $
				da[n]=star_error[ic].teff
			end
		'Alpha': begin
			if direction eq 1 then $
				star_model[ic].alpha=a[n] else $
				a[n]=star_model[ic].alpha
			da[n]=0.1
			end
		'Omega': begin
			if direction eq 1 then $
				star_model[ic].omega=a[n] < 0.99 else $
				a[n]=star_model[ic].omega
			da[n]=0.02
			end
		'Magnitude': begin
			if direction eq 1 then $
				star_model[ic].magnitudes(ch)=a[n] else $
				a[n]=star_model[ic].magnitudes(ch)
			da[n]=0.1
			if init then begin
				star_model[ic].magnitudes(ch)= $
					star_model[ic].magnitudes(ch)+da[n]
				calcmodel,/quiet
				star_model[ic].magnitudes(ch)= $
					star_model[ic].magnitudes(ch)-da[n]
				chisq=modelchisq()
				if chisq ne 0 then $
				star_error[ic].magnitudes(ch)= $
					sqrt(chisq0/(chisq/da[n]^2)) < da[n]
			endif else if fit_options.h $
				and star_error[ic].magnitudes(ch) ne 0 then $
				da[n]=star_error[ic].magnitudes(ch)
			end
	endcase
	endelse
	n=n+1
endfor
;
endif	; valid component
;
ENDFOR
;
if direction eq -1 then begin
	if n eq 0 then a=0 else a=a[0:n-1]
endif
;
end
