function modelparse,component,comp_1,comp_2
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For a given component, extract the two subcomponents and replace with
; stars and/or corresponding binary components as defined in model.
; Example: A-BC -> A,B-C.
; Return status: -1: error, 0: normal completion.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if componentparse(component,comp_1,comp_2) ne 0 then return,-1
;
for i=0,num_binary()-1 do begin
	if componentparse(binary_model[i].component,c1,c2) ne 0 then return,-1
	if c1+c2 eq comp_1 then comp_1=binary_model[i].component
	if c1+c2 eq comp_2 then comp_2=binary_model[i].component
endfor
;
flag=0
if strlen(comp_1) gt 1 and strpos(comp_1,'-') eq -1 then flag=1
if strlen(comp_2) gt 1 and strpos(comp_2,'-') eq -1 then flag=2
comp_12=[comp_1,comp_2]
if flag ne 0 then begin
	comp_12=comp_12[flag-1]
	print,'***Error(MODELPARSE): missing binary component for '+comp_12+'!'
	return,-1
endif
;
return,0
;
end
