function modelpos,epoch,vellist
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute the locations of stars in a multiple system by summing up
; positional offsets generated by the binary pairs. Each binary is centered
; on the location of its center of mass. The positions are right ascension
; and declination offsets.
;
; Also return the velocities in RA and Dec [mas/day].
;
; Note: epoch = JD - 2440000 !
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
MAS=1/3600000.d0
;
num_epoch=n_elements(epoch)
;
o_parms=dblarr(8)
poslist=dblarr(num_epoch,num_star(),2)
poslist_h=poslist
poslist_l=poslist
vellist=dblarr(num_epoch,num_star(),2)
complist=strarr(num_star())
;
epoch_l=epoch-min(binary_model.period)/1000
epoch_h=epoch+min(binary_model.period)/1000
;
FOR i=0,num_binary()-1 DO BEGIN
;
if componentparse(binary_model[i].component,comp_1,comp_2) eq -1 then return,-1
;
; Compute the component masses (=sum of stellar masses)
masses=componentmass(comp_1,comp_2,num_body,index_comp)
;
case binary_model[i].method of
;
;	Normal detached binary, positions derived from orbit
      1:begin
	o_parms[0]=binary_model[i].semimajoraxis
	o_parms[1]=binary_model[i].eccentricity
	o_parms[2]=binary_model[i].inclination/RAD
	o_parms[3]=binary_model[i].periastron/RAD
	o_parms[4]=binary_model[i].apsidalmotion/RAD
	o_parms[5]=binary_model[i].ascendingnode/RAD
	o_parms[6]=binary_model[i].period
	o_parms[7]=binary_model[i].epoch
	xy=true2app(epoch,o_parms,rho,theta,gen_model.ra,gen_model.dec)
	xy_h=true2app(epoch_h,o_parms,rho,theta,gen_model.ra,gen_model.dec)
	xy_l=true2app(epoch_l,o_parms,rho,theta,gen_model.ra,gen_model.dec)
	end
;
;	Normal detached binary, position from model values (rho,theta)
      2:begin
	xy=dblarr(n_elements(epoch),2)
	xy[*,0]=binary_model[i].rho*sin(binary_model[i].theta/RAD)
	xy[*,1]=binary_model[i].rho*cos(binary_model[i].theta/RAD)
	xy_l=xy
	xy_h=xy
	end
;
;	Here this is the same as method 2, i.e. ignore orbit for astrometry
      3:begin
	xy=dblarr(n_elements(epoch),2)
	xy[*,0]=binary_model[i].rho*sin(binary_model[i].theta/RAD)
	xy[*,1]=binary_model[i].rho*cos(binary_model[i].theta/RAD)
	xy_l=xy
	xy_h=xy
	end
;
;	Here this is the same as method 1
      4:begin
	o_parms[0]=binary_model[i].semimajoraxis
	o_parms[1]=binary_model[i].eccentricity
	o_parms[2]=binary_model[i].inclination/RAD
	o_parms[3]=binary_model[i].periastron/RAD
	o_parms[4]=binary_model[i].apsidalmotion/RAD
	o_parms[5]=binary_model[i].ascendingnode/RAD
	o_parms[6]=binary_model[i].period
	o_parms[7]=binary_model[i].epoch
	xy=true2app(epoch,o_parms,rho,theta,gen_model.ra,gen_model.dec)
	xy_h=true2app(epoch_h,o_parms,rho,theta,gen_model.ra,gen_model.dec)
	xy_l=true2app(epoch_l,o_parms,rho,theta,gen_model.ra,gen_model.dec)
	end
;
endcase
;
factor=[-masses[1]/total(masses),+masses[0]/total(masses)]
for k=0,1 do begin
	for j=0,num_body[k]-1 do begin
	    poslist[*,index_comp[j,k],*]=poslist[*,index_comp[j,k],*] $
					+factor[k]*xy
	endfor
endfor
;
; Accumulate positions for epoch_h, epoch_l
for k=0,1 do begin
	for j=0,num_body[k]-1 do begin
	    poslist_h[*,index_comp[j,k],*]=poslist_h[*,index_comp[j,k],*] $
					+factor[k]*xy_h
	endfor
endfor
for k=0,1 do begin
	for j=0,num_body[k]-1 do begin
	    poslist_l[*,index_comp[j,k],*]=poslist_l[*,index_comp[j,k],*] $
					+factor[k]*xy_l
	endfor
endfor
;
ENDFOR
;
; Compute derivatives
for k=0,1 do begin
for j=0,num_star()-1 do begin
	if epoch_h[0]-epoch_l[0] gt 0 then $
	vellist[*,j,k]=(poslist_h[*,j,k]-poslist_l[*,j,k])/(epoch_h-epoch_l)
endfor
endfor
;
return,poslist
;
end
