function modelpx,component,error
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute the parallax [mas] from data for any input binary component.
; The error estimate is somewhat conservative in that the
; masses are usually correlated, but this function just adds
; all stellar mass errors in quadrature.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(component) eq 0 then begin
	print,'Component not specified, assume A-B'
	component='A-B'
endif
;
if componentparse(strupcase(component),comp_1,comp_2) ne 0 then return,-1
mass_sum=total(componentmass(comp_1,comp_2))
i=where(binary_model.component eq strupcase(component)) & i=i[0]
parallax=binary_model[i].semimajoraxis $
	/(mass_sum*(binary_model[i].period/365.25)^2)^(1./3)
error=parallax*sqrt( $
	(binary_error[i].semimajoraxis/binary_model[i].semimajoraxis)^2 $
       +(total((star_error.mass/star_model.mass)^2)/9) $
       +(binary_error[i].period/binary_model[i].period)^2*(4./9))
return,parallax
;
end
