function modelvel,epochs,components
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute radial velocity of stars in a multiple system by adding up all the
; contributions from the binary pairs specified in components. If they are
; not passed, then all components are added, yielding the total velocities
; for each star. If, on the other hand, only the top binary component is
; passed, then the velocity of any star is just its motion around the
; common center of mass in the top binary component.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
mas2rad=pi_circle/(180L*3600L*1000L)
RAD=180/pi_circle
;
num_epoch=n_elements(epochs)
if n_elements(components) eq 0 then components=binary_model.component
;
o_parms=dblarr(8)
vellist=dblarr(num_epoch,num_star())+gen_model.rv
complist=strarr(num_star())
;
FOR ic=0,n_elements(components)-1 DO BEGIN
;
i=where(binary_model.component eq components[ic]) & i=i[0]
if i eq -1 then return,-1
if componentparse(binary_model[i].component,comp_1,comp_2) eq -1 then return,-1
;
; Compute the component masses (=sum of stellar masses)
masses=componentmass(comp_1,comp_2,num_body,index_comp)
;
o_parms[0]=binary_model[i].eccentricity
o_parms[1]=binary_model[i].inclination/RAD
o_parms[2]=binary_model[i].periastron/RAD
o_parms[3]=binary_model[i].apsidalmotion/RAD
o_parms[4]=binary_model[i].period
o_parms[5]=binary_model[i].epoch
o_parms[6]=masses[0]
o_parms[7]=masses[1]
;
if binary_model[i].method eq 4 then begin
	iband=binary_model[i].wdband	; save wdband
	binary_model[i].wdband=4	; RV measurements are taken in Y band
	binary_model[i].wdband=25	; RV measurements are taken in Hp-band
	binary_model[i].wdband=7	; RV measurements are taken in V-band
	binary_model[i].wdband=6	; RV measurements are taken in B-band
	v=lcmap(binary_model[i],epochs,2)
	if v[0] eq -1 then return,0
	binary_model[i].wdband=iband	; restore wdband
;	lamda=0.55e-6			; RV measurements are taken in V-band
;	v=wdrav(binary_model(i),epochs,lamda)-gen_model.rv
endif else begin
	v=true2vel(epochs,o_parms)
endelse
;
for k=0,1 do begin
	for j=0,num_body[k]-1 do begin
	    vellist[*,index_comp[j,k]]=vellist[*,index_comp[j,k]]+v[*,k]
	endfor
endfor
;
ENDFOR
;
return,vellist
;
end
