function modelvis,time,lamda,fluxes,u,v
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Computes complex visibility for a multiple star model.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common LocalModelVis,comp_fluxes,md5seed
;
; The number of elements in the binary model corresponds to the number of
; binary components (e.g. components like A-B, A-BC, AB-CD, etc.). The
; number of elements of the star model must correspond to the number of
; real stars involved in the entire model of the (multiple) stellar system.
;
if num_binary() gt 0 then begin
;	Hierarchical model
	comp_fluxes=fltarr(n_elements(lamda),num_star())
	levels=strlen(binary_model.component)
	i=where(max(levels) eq levels)
	modvis=componentvis(binary_model[i].component,time,lamda,fluxes,u,v)
; 	Check if there is a "dangling" uncorrelated flux component
	i=where(star_model.type eq 0,count)
	if count eq 1 then begin
		if strpos(strjoin(binary_model.component), $
			star_model[i].component) lt 0 then begin
		modvis_2= $
		componentvis(star_model[i].component,time,lamda,fluxes1,u,v)
		fluxes=fluxes+fluxes1
		endif
	endif
endif else if num_star() ge 1 then begin
;	Distribution of single components
	modvis=complexarr(n_elements(time),n_elements(lamda))
	fluxes=fltarr(n_elements(lamda))
;	For uvimage, which calls with num_scan=num_wave=1
	if n_elements(modvis) eq 1 then begin
                num_uv=n_elements(u)
                modvis=complexarr(num_uv)
	endif
	for i=0,num_star()-1 do begin
	modvis= $
	modvis+componentvis(star_model[i].component,time,lamda,fluxes1,u,v)
	fluxes=fluxes+fluxes1
	endfor
endif else begin
	print,'***Error(MODELVIS): model incomplete!'
	return,-1
endelse
;
return,modvis
end
