pro modfuncs,x,y,a,ymod,ysig,dyda,ma,ndata,ia
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common MarquardtFit,fit_options
;
f=fit_options.f
fit_options.f=0	; Do not scale visibilities when computing derivatives
;
; Store model parameters and get step sizes
modelparmcopy,1,a,deltaa
;
; Compute derivatives
b=a
dyda=dblarr(ndata,ma)
for j=0,ma-1 do begin
	if ia[j] gt 0 then begin
		b[j]=a[j]-deltaa[j]
		modelparmcopy,1,b
		calcmodel,/quiet
		marquardtdata,mrq_y,mrq_ysig,y_low
		b[j]=a[j]+deltaa[j]
		modelparmcopy,1,b
		calcmodel,/quiet
		marquardtdata,mrq_y,mrq_ysig,y_high
		dyda[*,j]=(y_high-y_low)/(2*deltaa[j])
		b[j]=a[j]
	endif
endfor
;
; Compute model
modelparmcopy,1,a
calcmodel,/quiet
marquardtdata,y,ysig,ymod
;
; Astrometry fits vary sigma based on the orientation of the uncertainty
; ellipse wrt to the model position
;
fit_options.f=f	; Restore original choice
;
end
