pro moiree
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Remove Moiree effect from AMBER MR differential phases (caused by
; polarizers, which were removed in 2008).
;
; Note: AMBER HR data need to be filtered with a low-pass filter.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
for i=0,genconfig.numoutbeam-1 do begin
for l=0,genconfig.numbaseline[i]-1 do begin
for k=0,n_elements(scans)-1 do begin
;
diffphase=reform(scans[k].diffphase(i,0:genconfig.numspecchan[i]-1,l))
scans[k].diffphasec(i,0:genconfig.numspecchan[i]-1,l)=highpass(diffphase)
vissqc=reform(scans[k].vissqc(i,0:genconfig.numspecchan[i]-1,l))
scans[k].vissqc(i,0:genconfig.numspecchan[i]-1,l)=highpass(vissqc)
;
endfor
endfor
endfor
;
end
