pro motorfit,ft=ft,rh=rh,bp=bp
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Tables,ScanTable,BGTable,StationTable
;
; Check presence of data
if checkdata([1,8,16,21]) ne 0 then return
;
if n_elements(feedvector) eq 0 then begin
	feedvector=dblarr(genconfig.numsid,3,n_elements(scantable))-1
	for i=0,GenConfig.NumSid-1 do feedvector[i,0,*]=scantable.starttime
endif
;
; The are the meteorological parameters for the index of refraction
if n_elements(ft) eq 0 then ft=56.3	; Fahrenheit
if n_elements(rh) eq 0 then rh=33.0	; relative humidity [%]
if n_elements(bp) eq 0 then bp=23.316	; pressure in inch-Hg
;
for i=0,GenConfig.NumSid-1 do begin
	y=lmmotor(x,a,/init,sid=i+1,ft=ft,rh=rh,bp=bp)
	fita=[1,1,1,1,0,0,0,1]
	fita=[1,1,1,1,1,0,1,1]
	r=lmfit(x,y,a,function_name='lmmotor',/double,conv=conv,sigma=e,fita=fita)
	if conv eq 1 then begin
		print,'Siderostat ',i+1,' RMS ["] = ',stddev(y-r)*3600
		m=sidmodel(i+1,a)
	endif
endfor
;
end
