function n2jy,mag
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return flux in Jy for a source of N-band magnitude. This flux would be one
; measured by IRAS, for example.
;
; Using Table 7.5 of Infrared Astronomy, in Allen's Astrophysical Quantities
;
mag=float(mag)
;
return,10^(-(mag-3.87)/2.5)
;
end
