function nameparse,name_in,delimiters,posns
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Parse a (single) string into array of words, using delimiters. If at least
; one of the delimiters is a NULL string (i.e. ''), parse into single
; characters, but removing the remaining (single character) delimiters.
; Delimiters default to space and tab characters.
;
if n_elements(delimiters) eq 0 then delimiters=[' ',string(09b)]
si=sort(strlen(delimiters))
delimiters=delimiters[si]
;
if n_elements(name_in) eq 1 then name=name_in[0] else name=name_in
;
if delimiters[0] eq '' then begin
	words=strarr(strlen(name))
	for i=0,strlen(name)-1 do words[i]=strmid(name,i,1)
	return,words
endif
;
n=0
j=0
in_word=0
words=''
de_length=1
for i=0l,strlen(name)-1 do begin
	delimiter=0
	for k=0,n_elements(delimiters)-1 do begin
		if strmid(name,i,strlen(delimiters[k])) $
		eq delimiters[k] then begin
			delimiter=1
			de_length=strlen(delimiters[k])
			if strlen(strtrim(delimiters[k])) eq 0 then isblank=1 $
							       else isblank=0
		endif
	endfor
	if delimiter then begin
		if in_word or not isblank then begin
			n=n+1
			words=strarr(n)
			posns=intarr(n)
			if n gt 1 then words[0:n-2]=old_words
			if n gt 1 then posns[0:n-2]=old_posns
			if in_word then words[n-1]=strmid(name,j,i-j)
			posns[n-1]=j
			old_words=words
			old_posns=posns
			j=i+de_length-1
			in_word=0
		endif
	endif else begin
		if in_word eq 0 then begin
			in_word=1
			j=i+de_length-1 ; starting point for current word
		endif
	endelse
endfor
if in_word eq 1 then begin
	n=n+1
	words=strarr(n)
	posns=intarr(n)
	if n gt 1 then words[0:n-2]=old_words
	if n gt 1 then posns[0:n-2]=old_posns
	words[n-1]=strmid(name,j,i-j)
	posns[n-1]=j
endif
return,words
;
end
