pro natrates,starid,predictedrate
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Propagate the stellar flux through the atmosphere and NPOI, and return
; the predicted count rate for every NPOI channel.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
; Get predicted count rate/cm^2/s/nm
rate=stellarrate[starid,lambda]
lambda=lambda*1e9
;
; Interpolate onto finer grid
l=findgen(500)+400
rates=spline(lambda,rate,l)
;
ci_t=1./500		; Coherent integration 2 ms
aper=3.14*(12.5/2)^2	; Aperture 12 cm
coat_t=0.99		; Transmission of coated surfaces
unct_t=0.96		; Transmission of uncoated surfaces
pickup=0.2		; Beam splitter pickup fraction
predictedrate=rates*atmosphere(l)*aper*silver(l)^18*pickup*coat_t^10*unct_t^2*ap
;
end
