function nightinfo
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Allocate structure for bufferinfo to hold information for tags of the
; scans and genconfig structures. Those two have to be present, but their
; contents are irrelevant.
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
num_tags=n_tags(scans)
num_levels=8	; Max expected number of data dimensions + 3
num_strings=0
for i=0,num_tags-1 do begin
	dims=size(scans.(i))
	if dims[dims[0]+1] eq 7 then num_strings=num_strings+1
endfor
;
nisc={size:lonarr(num_tags,num_levels), $
	maxlen:lonarr(num_strings+1), $
	NumScan:0}
;
num_tags=n_tags(genconfig)
num_levels=8	; Max expected number of data dimensions + 3
num_strings=0
for i=0,num_tags-1 do begin
	dims=size(genconfig.(i))
	if dims[dims[0]+1] eq 7 then num_strings=num_strings+1
endfor
;
nigc={size:lonarr(num_tags,num_levels),maxlen:lonarr(num_strings+1), $
	NumSid:0,NumOutBeam:0, $
	maxTriple:0,maxBaseline:0,maxChannel:0,maxConfig:0}
;
return,{file:'',xdr:0,nisc:nisc,nigc:nigc}
;
end
