pro npoiconfig
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Reads data base in npoi/config and solves for station and delay line
; based delays. The station part, D, can be used directly in stations.config.
; The delay line part has to have the beam combiner path contribution subtracted
; before using in fdl.config. The beam combiner contributions are listed in
; 6way.config.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
files=file_search(!oyster_dir+'npoi/opd/*.xdr')
if strlen(files[0]) eq 0 then nf=0 else nf=n_elements(files)
if nf eq 0 then return
s=''
status=dc_read_free(!oyster_dir+'npoi/stations.config',s,x,y,z,d,/col,ignore=['!
stations=s
ns=n_elements(stations)
cterms=fltarr(ns)
for i=0,ns-1 do cterms[i]=d[where(s eq stations[i])]
maxrow=1000
m=fltarr(maxrow,ns+6)
y=fltarr(maxrow)
n=0
for i=0,nf-1 do begin
	restore,files[i]
	for k=0,genconfig.numoutbeam-1 do begin
	for l=0,genconfig.numbaseline[k]-1 do begin
	i1=where(stations eq strmid(genconfig.baselineid[l,k],0,3))
	i2=where(stations eq strmid(genconfig.baselineid[l,k],4,3))
	m[n,i1]=+1 & m[n,i2]=-1
	i1=where(genconfig.stationid eq strmid(genconfig.baselineid[l,k],0,3))
	i2=where(genconfig.stationid eq strmid(genconfig.baselineid[l,k],4,3))
	m[n,ns-1+genconfig.delaylineid[i1]]=+1 & m[n,ns-1+genconfig.delaylineid[i2]]=-1
	y[n]=genconfig.stationcoord[3,i1]-genconfig.stationcoord[3,i2]
	n=n+1
	endfor
	endfor
endfor
ct=total(abs(m),1)
; ct=ct(0:ns-1)
index=where(ct gt 0,ns6)
ns=ns6-6
m=m[*,index]
stations=stations[index[0:ns-1]]
cterms=cterms[index[0:ns-1]]
;
n_a_l=2
m=m[0:n-1+n_a_l,*]
y=y[0:n-1+n_a_l]
if n_a_l gt 0 then begin
	m[n+0,0]=1 & y[n+0]=cterms[0]
	m[n+1,ns]=1
endif
tm=transpose(m)
n=tm#m
r=tm#y
svdc,n,w,u,v
index=where(w/max(w) lt 1e-6,count) & if count gt 0 then w[index]=0
s=svsol(u,w,v,r)
for i=0,ns-1 do print,stations[i],s[i],format='(a,f11.6)'
for i=0,5 do print,'Delayline ID',i+1,s[ns+i],format='(a,i,f11.6)'
;
end
