function npoifile,filename
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Extract date portion if one of the following standard NPOI files:
; YYYY-MM-DD.extension[.NNN.NN], with the following extensions below.
; (Raw HDS files have an additional scan.sub-scan extension.)
;
extensions=['.raw','.con','.coh','.cha','.inch']
i=0
repeat begin
	file=strmid(filename,0,strpos(filename,extensions[i]))
	i=i+1
endrep until strlen(file) ne 0 or i eq n_elements(extensions)
if strlen(file) ne 0 then begin
	while strpos(file,'/') ne -1 do $
		file=strmid(file,strpos(file,'/')+1,strlen(file))
endif else begin
	print,'Warning(NPOIFILE): non-standard extension!'
	if strpos(filename,'/') lt 0 then file=strmid(filename,0,10) $
				     else file='YYYY-MM-DD'
endelse
;
return,file
;
end
