pro npoipipe,confiles,calibrators=calstars,addcal=calstar,model=modelfile
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Automatically reduce and calibrate CONSTRICTOR data files from NPOI.
; Existing files with flagtables will be read and applied before automatic
; editing. CHAMELEON files and flagtables will be saved to folder "npoipipe".
;
; Use calibrators if specified instead of those with flag 'C', use addcal
; to add a calibrator to the list.
;
; If model is specified, it will be used to detect non-tracking baselines.
;
; Good test cases: 2002-02-01, 2006-11-21
;
common Hds,path,hds_file_stub
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SelDirs,nt_dir,nt_sel,st_dir,st_sel,x_dir,y_dir,z_dir,x_sel,y_sel,z_sel
common PlotDataInfo,plotscans,plotdata_x,plotdata_y,plotdata_y_bck
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
;
; For astrometry
common FitInfo,fit_stations,fit_stars,fit_data,fit_nights,fit_parms
;
if n_elements(confiles) eq 0 then begin
	confiles='*.con'
	print,'Processing all CONSTRICTOR files...'
endif
;
con_files=file_search(confiles)
if strlen(con_files[0]) eq 0 then begin
	print,'Files not found!'
	return
endif
;
if not file_test("npoipipe") then file_mkdir,"npoipipe"
;
FOR ifile=0,n_elements(con_files)-1 DO BEGIN
;
print,'========================================================================'
print,'Now processing file: ',con_files[ifile]
;
get_data,con_files[ifile]
hds_close
; !except=2	; uncomment for math debugging purposes
;
; Once file has been read, open output file for diagnostic messages
openw,unit,'npoipipe/'+hds_file_stub+'.txt',/get_lun
;
list_summary_chameleon,unit
printf,unit,'-----------------------------------------'
;
; Find out which stars are calibrators
index=where(startable.bflag eq 'C',count)
if count gt 0 then begin
	cal_stars=startable[index].starid
	printf,unit,'Found',count,' listed calibrators:',format='(a,i3,a)'
	printf,unit,cal_stars
	printf,unit,'-----------------------------------------'
endif else begin
	print,'Warning: no calibrator observation in this file: ', $
		con_files[ifile]
	continue
endelse
;
if n_elements(calstars) ne 0 then begin
	cal_stars=calstars
	printf,unit,'User choice for calibrator(s): '
	printf,unit,cal_stars
	printf,unit,'-----------------------------------------'
	index=whereequal(startable.starid,cal_stars,/words)
	if index[0] eq -1 then begin
		print,'Warning: no obs. for the selected calibrators in: ', $
		con_files[ifile]
		printf,unit,'No observations for the selected calibrators!'
		free_lun,unit
		spawn,'cat '+'npoipipe/'+hds_file_stub+'.txt'
		continue
	endif
endif
;
if n_elements(calstar) ne 0 then begin
	printf,unit,'Additional user choice for calibrator(s): '
	printf,unit,calstar
	printf,unit,'-----------------------------------------'
	for i=0,n_elements(calstar)-1 do begin
		index=where(cal_stars eq calstar[i],count)
		if count eq 0 then cal_stars=[cal_stars,calstar[i]]
	endfor
endif
;
; Reduce list of cal_stars to those which have actually been observed
index=whereequal(cal_stars,startable.starid)
cal_stars=cal_stars[index]
;
; Store V magnitudes for each scan
v_mag=fltarr(n_elements(scantable))
for i=0,n_elements(startable)-1 do begin
	index=where(scantable.starid eq startable[i].starid)
	v_mag[index]=startable[i].mv
endfor
;
; Background data plotting initialization
if init_plot('bg','pt') ne 0 then return
create_bgflagtable
load_flagtable,'bg'
index=where(bgflagtable.time ge 0,count)
if count ne 0 then flagbgdata,bgflagtable[index],flag=1
;
; Flag Alpha Lab data (however, these might not have BG measurements anyway)
; index=where(bgflagtable.time ge 0,id0) & id=id0
; index=whereequal(scantable.scanid,bgtable.scanid)
; index=where(scantable(index).starid eq 'FKV0000',count)
; for i=0,count-1 do begin
; for ob=0,genconfig.numoutbeam-1 do begin
; for ch=0,genconfig.numspecchan(ob)-1 do begin
; 	bgflagtable(id).reason='PIPE AlpLab'
; 	bgflagtable(id).item=19
; 	bgflagtable(id).outbeam=ob
; 	bgflagtable(id).channel=ch
; 	bgflagtable(id).time=abs(bgscans(index(i)).time)
; 	id=id+1
; endfor
; endfor
; endfor
; if count gt 0 then flagbgdata,bgflagtable(id0:id-1)
medianbg
expandbg
;
; Save bgflagtable
save_flagtable,'bg',folder='npoipipe'
;
; Point data plotting initialization
if init_plot('point','pt') ne 0 then return
create_pointflagtable
load_flagtable,'point'
index=where(pointflagtable.time ge 0,count)
if count ne 0 then flagpointdata,pointflagtable[index],flag=1
;
; Flag very low delay jitter values (baseline not tracking)
index=where(scantable.code eq 0,count)
for i=0,count-1 do $
	delayjitter[*,*,rec0[index[i]]:recn[index[i]]]=1e-6
for ob=0,genconfig.numoutbeam-1 do begin
	ds_y.ob=ob
	for bl=0,genconfig.numbaseline[ob]-1 do begin
		y_dir.bl='Selected'
		y_sel.bl[0]=bl+1	; Human input convention of OYSTER
		ds_y.item=10		; DelayJitter
		set_plotsel
		plotdata,2,'ZERO DJITTR'
	endfor
endfor
;
; Attempt to get an estimate of the median delayjitter from all calibrators
dj=delayjitter
dje=delayjittererr
for i=0,n_elements(scantable)-1 do begin
	index=where(cal_stars eq scantable[i].starid,count)
	if count eq 0 then dj[*,*,rec0[i]:recn[i]]=0
endfor
med_dj=fltarr(max(genconfig.numbaseline),genconfig.numoutbeam)
med_dje=fltarr(max(genconfig.numbaseline),genconfig.numoutbeam)
for ob=0,genconfig.numoutbeam-1 do begin
for bl=0,genconfig.numbaseline[ob]-1 do begin
	dj_v=reform(dj[ob,bl,*])
	dj_e=reform(dje[ob,bl,*])
	index=where(dj_v gt 0.1e-6 and dj_e gt 0,count)
	if count gt 3 then begin
		med_dj[bl,ob]=medianve(dj_v[index],e)
		med_dje[bl,ob]=e
	endif
endfor
endfor
med_dj_all=med_dj	; Use this as reference for the alternative method
med_dj=med_dj*1e6	; plotdata uses microns
med_dje=med_dje*1e6
;
; Alternative method of first determining median for each cal., then averaging
med_dj=fltarr(max(genconfig.numbaseline),genconfig.numoutbeam)
med_dje=fltarr(max(genconfig.numbaseline),genconfig.numoutbeam)
nblob=intarr(max(genconfig.numbaseline),genconfig.numoutbeam)
for i=0,n_elements(cal_stars)-1 do begin
	dj=delayjitter
	dje=delayjittererr
	index=where(scantable.starid ne cal_stars[i],count)
	for j=0,count-1 do begin
		dj[*,*,rec0[index[j]]:recn[index[j]]]=0
		dje[*,*,rec0[index[j]]:recn[index[j]]]=0
	endfor
	for ob=0,genconfig.numoutbeam-1 do begin
	for bl=0,genconfig.numbaseline[ob]-1 do begin
		dj_v=reform(dj[ob,bl,*])
		dj_e=reform(dje[ob,bl,*])
;		Do not include outliers in the following
		index=where(dj_v gt 0.1e-6 and dj_e gt 0 $
			and dj_v lt med_dj_all[bl,ob]*5,count)
;		Accumulate average
		if count gt 3 then begin
			v=medianve(dj_v[index],ve)
;			med_dj(bl,ob)=med_dj(bl,ob)+mean(dj_v(index))
			med_dj[bl,ob]=med_dj[bl,ob]+v
			med_dje[bl,ob]=med_dje[bl,ob]+ve
			nblob[bl,ob]=nblob[bl,ob]+1
		endif
	endfor
	endfor
endfor
med_dj=med_dj/(nblob > 1)
med_dje=med_dje/(nblob > 1)
med_dj=med_dj*1e6	; plotdata uses microns
med_dje=med_dje*1e6	; plotdata uses microns
;
; Process station based data
for ib=0,genconfig.numsid-1 do begin
	if max(natcounts[ib,*]) gt 0 and max(natcountserr[ib,*]) gt 0 then begin
	ds_y.ib=ib
	ds_y.item=11	; NATJitter
	set_plotsel
	plotdata,1,'AUTO NATJITTER'
	y_med=median(plotscans.y[where(plotscans.ye gt 0)])
	ben_rms=[0.35,0.30,0.25,0.20,0.15,0.10,0.05]*sqrt(2)
	ben_bno=['B0','B1','B2','B3','B4','B5','B6']
	bno=ben_bno[0]
	for i=0,n_elements(ben_bno)-1 do $
		if y_med lt ben_rms[i] then bno=ben_bno[i]
;
	ds_y.item=12	; NATCounts
	plotdata,1,'AUTO NATCOUNTS'
;
	index=where(plotscans.y gt 0 and v_mag ne 100)
	c0=plotscans.y[index]/10^(-v_mag[index]/2.5)
	c0=mean(c0)
;
;	Print diagnostic info
;	printf,unit,'Station '+string(ib+1,format='(i1)')+':'
	printf,unit,'Station '+genconfig.stationid[ib]+':'
	printf,unit,'Seeing (Burress scale): '+bno
	printf,unit,'NAT counts for zero magnitude star: ' $
			+string(c0,format='(i5)')
	printf,unit,'-----------------------------------------'
	endif
endfor
;
; Process baseline based data
for ob=0,genconfig.numoutbeam-1 do begin
	ds_y.ob=ob
	y_dir.ch='All'
	y_dir.bl='All'
	ds_y.item=8	; Photonrate
	if genconfig.numbaseline[ob] ge 1 then begin
	set_plotsel
	plotdata,1,'AUTO PHOTONRATE'
	for bl=0,genconfig.numbaseline[ob]-1 do begin
		y_dir.bl='Selected'
		y_sel.bl=bl+1	; Human input convention of OYSTER
		ds_y.item=10	; DelayJitter
		set_plotsel
		plotdata,1,'AUTO'+' '+string(med_dj[bl,ob]*4, $
						format='(f4.1)')
		ds_y.item=3	; VisSq
		plotdata,1,'AUTO VISSQ'
	endfor
	endif
endfor
;
; Save pointflagtable
save_flagtable,'point',folder='npoipipe'
;
; Average the pointdata
average
;
; Do the astrometry
list_stations,fit_stations
index=where(total(scantable.station[0:GenConfig.NumSid-1,*],2) ne 0,count)
fit_stations=fit_stations[index]
fit_stars=''
fit_data='FDL'
; solveastrom	; Skip for now, as there can be bad data
;
; Do the bias computations
!quiet=1
print,'Computing bias corrections...'
index=where(scantable.code eq 0,count)
if count gt 0 then begin
	if init_plot('ncal','pt') ne 0 then return
	ps_options.a=1
	type='V2Bias'
	configs=scanconfig(/coh)
	st_dir='Sel'
;	GDL cannot make multiple-page PS plots, one could use this command:
;	gs -sDEVICE=pswrite -sOutputFile=output.ps -dNOPAUSE -dBATCH file*.ps
	if !idl then set_ps,'npoipipe/'+date+'.ps',/color
	for ob=0,genconfig.numoutbeam-1 do begin
	if genconfig.numbaseline[ob] ge 1 then begin
		ds_y.ob=ob
		y_dir.ch='All'
		y_dir.bl='All'
;		First, make sure every star has a bias value
		index=where(startable.starid ne 'FKV0000')
		st_sel=startable[index].starid
		for i=0,n_elements(configs)-1 do begin
			y_dir.pt=configs[i]
			set_plotsel
			if !idl then plotncal else plotncal,/skip_plot
		endfor
;		Now, we improve by just using data of single stars
		for k=0,n_elements(startable)-1 do begin
			if startable[k].starid ne 'FKV0000' then begin
			st_sel=startable[k].starid
			s=startable[k].starid
			list_scans,s,/coh
			configs_star=unique(scanconfig(s))
			for i=0,n_elements(configs_star)-1 do begin
				y_dir.pt=configs_star[i]
				set_plotsel
				if !idl then plotncal else plotncal,/skip_plot
			endfor
			endif
		endfor
	endif
	endfor
	type='TABias'
	for tr=0,genconfig.numtriple-1 do begin
		ds_y.tr=tr
		y_dir.ch='All'
;		First, make sure every star has a bias value
		index=where(startable.starid ne 'FKV0000')
		st_sel=startable[index].starid
		for i=0,n_elements(configs)-1 do begin
			y_dir.pt=configs[i]
			set_plotsel
			if !idl then plotncal else plotncal,/skip_plot
		endfor
;		Now, we improve by just using data of single stars
		for k=0,n_elements(startable)-1 do begin
			if startable[k].starid ne 'FKV0000' then begin
			st_sel=startable[k].starid
			s=startable[k].starid
			list_scans,s,/coh
			configs_star=unique(scanconfig(s))
			for i=0,n_elements(configs_star)-1 do begin
				y_dir.pt=configs_star[i]
				set_plotsel
				if !idl then plotncal else plotncal,/skip_plot
			endfor
			endif
		endfor
	endfor
	if !idl then device,/close
	set_screen
	ps_options.a=0
endif
!quiet=0
;
; Average again, now that we determined the bias corrections
average
;
; Flag incoherent scans
print,'Flagging incoherent scans...'
create_scanflagtable
load_flagtable,'scan'
index=where(scanflagtable.time ge 0,count)
if count ne 0 then flagscandata,scanflagtable[index],flag=1
index=where(scantable.code eq 0,count)
if count gt 0 then flagscandata,sc=index+1,item=24,reason='AUTO Incoh'
;
; We found there are nights with bad station coordinates
scd=genconfig.stationcoord
get_stationtable
sct=genconfig.stationcoord
d=fltarr(genconfig.numsid)
for i=0,genconfig.numsid-1 do d[i]=sqrt(total((scd[0:2,i]-sct[0:2,i])^2))
if max(d) gt 0.05 then begin
;	Find station(s) with large differences
	largeDiff = where(d gt 0.05)
	problems=' '
	FOREACH stationid,largeDiff DO problems=problems+genconfig.stationid[stationid]
	printf,unit,'Warning: problem with station coordinates!'
        printf,unit,'Stations with large differences are: ',problems
        printf,unit,'Differences (m) are: ',d[largeDiff]
        printf,unit,'Astrometry will be calculated with coordinates from system.
	genconfig.stationcoord=scd
	calcastrom
	printf,unit,'-----------------------------------------'
endif else begin
;	No problem, revert station coordinates to system.config numbers
	genconfig.stationcoord=scd
endelse
;
; Attempt to calibrate the data
;
print,'Calibrating data...'
cal_stars0=cal_stars	; initcal resets the calibrator selection
initcal
cal_stars=cal_stars0
create_calentries
;
; Make sure no false coherent scans are present
index=where(total(scantable.station[0:genconfig.numsid-1,*],1) eq 0,count)
if count gt 0 then scantable[index].code=0
;
; Obtain scan index corresponding to calibrator selection
list_stars,stars
mask=intarr(n_elements(scans))
for k=0,n_elements(stars)-1 do begin
	index=where(cal_stars eq stars[k],count)
	if count eq 0 then begin
		index=where(scans.StarId eq stars[k])
		mask[index]=-1
	endif
endfor
calscan_index=where(mask eq 0 and scantable.code eq 1,calscan_count)
;
; We should attempt to check for outliers in the calibrator visibilities
index=where(scanflagtable.time ge 0,id0) & id=id0
configs=scanconfig(/coh)
badcals=''
low_vsq_limit=0.02	; Visibilities below this value should be flagged
;
for ob=0,genconfig.numoutbeam-1 do begin
for bl=0,genconfig.numbaseline[ob]-1 do begin
for cf=0,n_elements(configs)-1 do begin
	index=whereequal(calscan_index,scanconfig(configs[cf],/coh)-1)
	if index[0] ne -1 then begin
;	Only flag entire scans, not individual channels
	v2med=fltarr(genconfig.numspecchan[ob])
	for ch=0,genconfig.numspecchan[ob]-1 do begin
		v2cal=scans[calscan_index[index]].vissqe(ob,ch,bl)
		e2cal=scans[calscan_index[index]].vissqeerr(ob,ch,bl)
		times=scans[calscan_index[index]].time/3600
		k=where(e2cal gt 0,count)
		if count gt 0 then v2med[ch]=median(v2cal[k])
	endfor
	j=where(v2med gt 0,count)
	if count gt 0 then begin
	for k=0,n_elements(index)-1 do begin
		v2cal=reform(scans[calscan_index[index[k]]].vissqe(ob,*,bl))
		if mean(v2cal[j]/v2med[j]) lt 0.5 then begin
		for ch=0,genconfig.numspecchan[ob]-1 do begin
				scanflagtable[id].reason='AUTO Calib'
				scanflagtable[id].item=24
				scanflagtable[id].baseline=bl
				scanflagtable[id].channel=ch
				scanflagtable[id].outbeam=ob
				scanflagtable[id].time= $
				abs(scans[calscan_index[index[k]]].time)
				id=id+1
		endfor
		endif
	endfor
	endif
	endif
endfor
endfor
endfor
if n_elements(badcals) gt 1 then begin
	badcals=unique(badcals[0:n_elements(badcals)-1])
	printf,unit,'Calibrators with outliers: ',badcals
endif
if id gt id0 then flagscandata,scanflagtable[id0:id-1]
;
; Calibrate
if init_plot('scan','pt') ne 0 then return
cal_options.v=0	; Vissq
reason='npoipipe_v2'
st_dir='All'
cal_options.l=1
sel_indct[0]='Time'
sel_funcn[0]='S_80'
printf,unit,''
printf,unit,'Calibrating (squared) visibilities...'
for ob=0,genconfig.numoutbeam-1 do begin
	if genconfig.numbaseline[ob] ge 1 then begin
	ds_y.ob=ob
	y_dir.ch='All'
	y_dir.bl='All'
	configs=scanconfig(/coh)
	for i=0,n_elements(configs)-1 do begin
		y_dir.pt=configs[i]
		set_plotsel
		print,'Calibrating configuration ',configs[i]
		printf,unit,''
		printf,unit,'Calibration of configuration ',configs[i]
		printf,unit,'Calibration by: ',sel_indct[0]
                printf,unit,'Calibration function: ',sel_funcn[0]
		printf,unit,'*********************************'
                printf,unit,' '
		calcoeffs,reason,unit
	endfor
	endif
endfor
calibrate,reason
;
; Unwrap the triple phases of the calibrators
!quiet=1
na=18	; Number of angles to rotate
sd=fltarr(na)
scans_unwrapped=scans
for tr=0,genconfig.numtriple-1 do begin
	good_channel_index=total(reform(scans.tripleamperr[tr,*] > 0),2)
	gci=where(good_channel_index ne 0,ngc)
	IF ngc gt 0 THEN BEGIN
	v=reform(scans[calscan_index].triplephasec(tr,gci))
	e=reform(scans[calscan_index].triplephasecerr(tr,gci))
	index=where(total(reform(e>0),1) gt 0,count)
	IF count gt 0 THEN BEGIN
	ve=v[*,where(total(reform(e>0),1) gt 0)]
	ee=e[*,where(total(reform(e>0),1) gt 0)]
;	Only include valid data points with error less than 1 radian
	index=where(ve gt 0 and ee lt 1,count) & vgz=0 & megz=0
	if count gt 1 then vgz=medianve(ve[index],megz)
	index=where(ve lt 0 and ee lt 1,count) & vlz=0 & melz=0
	if count gt 1 then vlz=medianve(ve[index],melz)
	if vgz-vlz gt !pi and megz lt !pi/5 and melz lt !pi/5 then begin
; 		Either we have bimodal phases...
		for ch=0,genconfig.triplenumchan[tr]-1 do begin
		index=where(scans[calscan_index].triplephasec(tr,ch) lt -!pi/2)
		if index[0] ne -1 then $
		scans_unwrapped[calscan_index[index]].triplephasec(tr,ch)= $
		scans_unwrapped[calscan_index[index]].triplephasec(tr,ch)+2*!pi
		endfor
	endif else begin
;		...or we deal with drift due to excess dispersion
		scans_bck=scans	; make copy because rewraptriple does all scans
		for ia=0,na-1 do begin
			rewraptriple,(360./na)*ia
			v=reform(scans[calscan_index].triplephasec(tr,gci))
			e=reform(scans[calscan_index].triplephasecerr(tr,gci))
			index=where(total(reform(e>0),1) gt 0,count)
			if count ge ngc and ngc gt 2 then begin
				a=total(v[*,where(total(reform(e>0),1) gt 0)],2)
				r=poly_fit(gci,a,2,yfit)
				sd[ia]=stddev(a-yfit)
			endif
		endfor
		index=where(sd eq 0,count)
		if count gt 0 then sd[index]=max(sd)
		index=where(sd eq min(sd))
		angle=(360./na)*index[0]
		if angle gt 180 then angle=angle-360
		rewraptriple,angle
		scans_unwrapped[calscan_index].triplephasec(tr,*)= $
			  scans[calscan_index].triplephasec(tr,*)
		scans=scans_bck
	endelse
	ENDIF
	ENDIF
endfor
scans=scans_unwrapped
!quiet=0
;
; Calibrate triple amplitudes
reason='npoipipe_v3'
cal_options.v=1 ; TripleAmp
printf,unit,'Calibrating triple amplitudes...'
for tr=0,genconfig.numtriple-1 do begin
	ds_y.tr=tr
	y_dir.ch='All'
;	ds_y.ch=indgen(genconfig.triplenumchan(tr))
	y_dir.pt='All'
	configs=scanconfig(/coh)
	for i=0,n_elements(configs)-1 do begin
		y_dir.pt=configs[i]
		set_plotsel
		print,'Calibrating configuration ',configs[i]
		printf,unit,'Calibration of configuration ',configs[i]
		calcoeffs,reason,unit
	endfor
endfor
calibrate,reason
; Calibrate triple phases
reason='npoipipe_p3'
cal_options.v=2 ; TriplePhase
printf,unit,'Calibrating triple phases...'
for tr=0,genconfig.numtriple-1 do begin
	ds_y.tr=tr
	y_dir.ch='All'
;	ds_y.ch=indgen(genconfig.triplenumchan(tr))
	y_dir.pt='All'
	configs=scanconfig(/coh)
	for i=0,n_elements(configs)-1 do begin
		y_dir.pt=configs[i]
		set_plotsel
		print,'Calibrating configuration ',configs[i]
		printf,unit,'Calibration of configuration ',configs[i]
		calcoeffs,reason,unit
	endfor
endfor
calibrate,reason
;
; Add calibration errors in quadrature
y_dir.pt='All'
set_plotsel
set_viserrors
;
; Finally, we flag data on baselines which appear to be non-tracking,
; i.e. those where the observed visibilities are less than 0.5 times the model.
; Flagtable entries for this action are not saved.
;
if n_elements(modelfile) eq 0 then modelfile=''
model_file=file_search(modelfile)
if n_elements(model_file) eq 1 and strlen(model_file[0]) ne 0 then begin
;
readmodel,model_file
calcmodel
index=where(scantable.starid eq gen_model.starid and scantable.code eq 1)
;
if index[0] ne -1 then begin
;
fndex=where(scanflagtable.time ge 0,id0) & id=id0
for ob=0,genconfig.numoutbeam-1 do begin
for bl=0,genconfig.numbaseline[ob]-1 do begin
;	Only flag entire baselines, not individual channels
	for k=0,n_elements(index)-1 do begin
		v2cal=reform(scans[index[k]].vissqc(ob,*,bl))
		v2mod=reform(scans[index[k]].vissqm(ob,*,bl))
		j=where(reform(scans[index[k]].vissqcerr(ob,*,bl)) gt 0,count)
		if count gt 0 then begin
		if mean(v2cal[j]/v2mod[j]) lt 0.5 then begin
		for ch=0,genconfig.numspecchan[ob]-1 do begin
				scanflagtable[id].reason='AUTO Model'
				scanflagtable[id].item=24
				scanflagtable[id].baseline=bl
				scanflagtable[id].channel=ch
				scanflagtable[id].outbeam=ob
				scanflagtable[id].time= $
				abs(scans[index[k]].time)
				id=id+1
		endfor
		endif
		endif
	endfor
endfor
endfor
if id gt id0 then flagscandata,scanflagtable[id0:id-1]
;
; Do the same with the triple amplitudes data
if 0 then begin	; Not tested well yet
fndex=where(scanflagtable.time ge 0,id0) & id=id0
for tr=0,genconfig.numtriple-1 do begin
	for k=0,n_elements(index)-1 do begin
		t3cal=reform(scans[index[k]].tripleampc(tr,*))
		t3mod=reform(scans[index[k]].tripleampm(tr,*))
		j=where(reform(scans[index[k]].tripleampcerr(tr,*)) gt 0,count)
		if count gt 0 then begin
		if mean(t3cal[j]/t3mod[j]) lt 0.5 then begin
		for ch=0,genconfig.triplenumchan[tr]-1 do begin
				scanflagtable[id].reason='AUTO Model'
				scanflagtable[id].item=28
				scanflagtable[id].channel=ch
				scanflagtable[id].outbeam=tr
				scanflagtable[id].time= $
				abs(scans[index[k]].time)
				id=id+1
		endfor
		endif
		endif
	endfor
endfor
if id gt id0 then flagscandata,scanflagtable[id0:id-1]
endif
;
endif
endif
;
; Save flagtable
save_flagtable,'scan',folder='npoipipe'
;
; Write to cha file
put_scandata,'npoipipe/'+hds_file_stub+'.cha'
;
; Close diagnostic output file and print information to screen
free_lun,unit
spawn,'cat '+'npoipipe/'+hds_file_stub+'.txt'
;
ENDFOR
;
; Do QC on pipeline log files
npoipipeqc
;
end
