pro npoipipelatex,pipefile
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
files=file_search(pipefile)
if strlen(files[0]) eq 0 then begin
	print,'Files not found!'
	return
endif
;
openw,unit,'npoiplot.tex',/get_lun
printf,unit,'\documentclass[a4paper,12pt]{article}'
printf,unit,'\pagestyle{empty}'
; https://www.sharelatex.com/learn/Page_size_and_margins
printf,unit,'\usepackage{geometry}'
printf,unit,'\geometry{left=20mm,top=0mm,}'
printf,unit,'\usepackage{graphicx}'
printf,unit,'\usepackage{subcaption}'
printf,unit,'\begin{document}'
printf,unit,'\begin{figure}[htb]'
printf,unit,'\centering'
; https://en.wikibooks.org/wiki/LaTeX/Tables#.40-expressions
printf,unit,'\begin{tabular}{@{}cccc@{}}'
istring='\includegraphics[width=0.32\textwidth]'
;
for i=0,n_elements(files)-1 do begin
;
	if (i+1) mod 3 eq 0 then t=' & \\' else t=' &'
	printf,unit,istring+'{'+files[i]+'}'+t
	if (i+1) mod 21 eq 0 then begin
		printf,unit,'\end{tabular}'
		printf,unit,'\caption{$\chi^2$ surfaces}'
		printf,unit,'\end{figure}'
		printf,unit,'\begin{figure}[htb]'
		printf,unit,'\centering'
		printf,unit,'\begin{tabular}{@{}cccc@{}}'
	endif
;
endfor
;
printf,unit,'\end{tabular}'
printf,unit,'\caption{$\chi^2$ surfaces}'
printf,unit,'\end{figure}'
printf,unit,'\end{document}'
free_lun,unit
spawn,'latex npoiplot'
spawn,'dvips -o npoiplot.ps npoiplot.dvi'
spawn,'ps2pdf npoiplot.ps'
;
end
