pro obsbase,files
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read ScanTable in HDS-format files, concatenate, and add to database,
; if database refers to an existing file. Otherwise, create database.
; The datebase file is kept in the npoi folder.
;
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_params() eq 0 then begin
	print,'Usage: obsbase,files'
	print,'Required input: files.'
	return
endif
;
if n_elements(files) eq 1 then files=file_search(files[0])
if strlen(files[0]) eq 0 then begin
	print,'***Error(OBSBASE): no files!'
	return
endif
hds_close
;
for i=0,n_elements(files)-1 do begin
	print,'Processing ',files[i]
	hds_open,files[i],'READ',status
	if status eq 0 then begin
		get_scantable
		get_sysconfig
		dat_annul
;
		if scantable[0].starttime/3600 gt 24 then $
			Date=nextdate(Date)
;
		scantable=scantable[where(scantable.code eq 1)]
		ns=n_elements(scantable)
		if i eq 0 then begin
			dates=strarr(ns)+Date
			stars=scantable.starid
			times=scantable.starttime
		endif else begin
			dates=[dates,strarr(ns)+Date]
			stars=[stars,scantable.starid]
			times=[times,scantable.starttime]
		endelse
	endif
;
endfor
parsedate,dates,y,m,d
umjd=unique(long(julian(y,m,d+times/86400,/mjd)*1000))
;
name=!oyster_dir+'npoi/obsbase.xdr'
result=file_search(name,count=fcount)
if fcount eq 1 then begin
	restore,name
	mask=intarr(n_elements(database))+1
	parsedate,database.date,y,m,d
	mjd=long(julian(y,m,d+database.time/86400,/mjd)*1000)
	for i=0,n_elements(umjd)-1 do begin
		index=where(mjd eq umjd[i],count)
		if count gt 0 then mask[index]=0
	endfor
	database=database[where(mask eq 1)]
	dates=[dates,database.date]
	stars=[stars,database.star]
	times=[times,database.time]
endif
database=alloc_obsbase(dates,stars,times)
entries=database.date+database.star+string(database.time)
database=database[uniq(entries,sort(entries))]
;
save,database,filename=name
;
if fcount eq 1 then print,'Database updated' else print,'Database created'
;
end
