pro obsdates,star,dates,scans
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Find dates of observation for a given star.
;
;
if n_params() eq 0 then begin
	print,'Usage: obsdates,star,dates,scans'
	print,'Required input: star.'
	return
endif else star=strupcase(star)
;
name=!oyster_dir+'npoi/obsbase.xdr'
result=file_search(name,count=fcount)
if fcount eq 0 then begin
        print,'***Error(OBSSTARS): file not found!'
        return
endif
restore,name
;
if n_elements(star) eq 0 then begin
	print,'***Error(OBSDATES): star not specified!'
	return
endif
;
index=where(database.star eq star,count)
if count eq 0 then begin
	print,'Warning(OBSDATES): star not found!'
	dates=''
	scans=0
	return
endif
database=database[index]
dates=database.date
if count gt 1 then dates=dates[uniq(dates,sort(dates))]
;
num_dates=n_elements(dates)
scans=intarr(num_dates)
for i=0,num_dates-1 do begin
	index=where(database.date eq dates[i] $
		and database.star eq star,count)
	scans[i]=count
endfor
;
if n_params() ne 3 then begin
	n_d_p_l=7
	while(printindex(num_dates,n_d_p_l,i,j)) do begin
		print,dates[i:j]
		print,string(scans[i:j],format='(i7)')+'   '
	endwhile
endif
;
end
