pro obslog2tex,target,aas=aas
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Version for 73 Leo paper
;
; Based on currently loaded interferometry reduced and calibrated by npoipipe,
; a log of the observations including calibrators is prepared for the specified
; target in A&A LaTex format (or AAS if aas=1). Calibrator ID are from BSC (HR).
;
common StarBase,StarTable,Notes
common Tables,scantable,bgtable,stationtable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
; Make copy of startable as it will be modified in this procedure
startable_bck=startable
;
if n_elements(target) eq 0 then begin
	target=''
	read,target,prompt='Please enter name of target: '
endif
if n_elements(aas) eq 0 then aas=0
;
months=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']
;
obslog=target+'_log.tex'
openw,unit,obslog,/get_lun
;
IF aas THEN BEGIN
;
; Use AASTEX
printf,unit,'\documentclass{/home/chummel/latex/aastex/aastex61}'
; printf,unit,'\usepackage{lscape}'
printf,unit,'\begin{document}'
printf,unit,'\begin{deluxetable}{lccccc}'
; printf,unit,'\rotate'
printf,unit,'\tabletypesize{\scriptsize}'
printf,unit,'\tablecaption{Observation and result log for ' $
	    +target+'\label{table1}}'
printf,unit,'\tablehead{'
printf,unit,'\colhead{UT Date}&'
printf,unit,'\colhead{\# of obs.}&'
printf,unit,'\colhead{Triangles and baselines}&'
printf,unit,'\colhead{Max. length}&'
printf,unit,'\colhead{\# of vis.}&'
printf,unit,'\colhead{\# of C. Ph.}'
printf,unit,'\\'
printf,unit,'\colhead{(1)}&'
printf,unit,'\colhead{(2)}&'
printf,unit,'\colhead{(3)}&'
printf,unit,'\colhead{(4)}&'
printf,unit,'\colhead{(5)}&'
printf,unit,'\colhead{(6)}'
printf,unit,'}'
printf,unit,'\startdata'
;
ENDIF ELSE BEGIN
;
printf,unit,'\documentclass[twocolumn]{/home/chummel/latex/aa-package/aa}'
printf,unit,'\usepackage{graphicx}'
printf,unit,'\usepackage{txfonts}'
printf,unit,'\usepackage{natbib}'
printf,unit,'\usepackage{upgreek}'
printf,unit,'\usepackage{url}'
printf,unit,'\begin{document}'
printf,unit,'\begin{table}'
printf,unit,'\caption{NPOI observations of '+target+' }'
printf,unit,'\label{npoilog}'
; printf,unit,'\begin{tabular}{llll}'
printf,unit,'\begin{tabular}{llllll}'
printf,unit,'\hline'
printf,unit,'\hline'
; printf,unit,'UT Date&Julian Year&Triangles and baselines&Calibrators (HR)\\'
; printf,unit,' (1) & (2) & (3) & (4) \\'
printf,unit,'UT Date&Julian Year&Triangles and baselines&'+ $
	    '$B_{\rm min} [m]$&$B_{\rm max} [m]$&Calibrators (HR)\\'
printf,unit,' (1) & (2) & (3) & (4) & (5) & (6) \\'
printf,unit,'\hline'
;
ENDELSE
;
nights=GenInfo.date
arrays=GeoInfo.systemid
confgs=GenInfo.configid
;
FOR n=0,n_elements(nights)-1 DO BEGIN
;
; Load data
night=where(GenInfo.date eq nights[n] $
        and GeoInfo.systemid eq arrays[n] $
        and GenInfo.configid eq confgs[n],count)
if count eq 0 and n_elements(GenInfo.date) eq 1 then night=0
if strupcase(!version.os) ne 'WIN32' $
	and n_elements(bufferinfo) gt 1 then begin
	loadnight,GenInfo[night[0]].date, $
		GeoInfo[night[0]].systemid, $
		GenInfo[night[0]].configid
endif
;
; Master index for target scans
index=where(scans.starid eq target and scantable.code eq 1,num_scans)
vndex=where(scans[index].vissqcerr gt 0,num_vis)
tndex=where(scans[index].triplephasecerr gt 0,num_triple)
;
; Prepare for baseline length computation
uvw=scans[index].uvw
bl_max=intarr(max(genconfig.numbaseline),genconfig.numoutbeam)
bl_min=bl_max
;
; Date and Julian Year
parsedate,geninfo[n].date,year,month,day
day=day+median(scans[index].time)/86400
jy=jd2jy(julian(year,month,day))
utdate=strmid(geninfo[n].date,0,4) $
	+' '+months[month-1] $
	+' '+strmid(geninfo[n].date,8,2)
;
; Maximum baseline lengths
if genconfig.numtriple gt 0 then begin
baseids=genconfig.baselineid[ $
	genconfig.triplebase[*,0:genconfig.numtriple-1], $
	genconfig.triplebeam[*,0:genconfig.numtriple-1]]
endif else baseids=genconfig.baselineid
for i=0,genconfig.numoutbeam-1 do begin
for j=0,genconfig.numbaseline[i]-1 do begin
	for m=0,1 do uvw[i,*,j,m,*]=uvw[i,*,j,m,*] $
		   *(genconfig.wavelength[*,i]#(fltarr(n_elements(index))+1))
	uv=reform(sqrt(uvw[i,*,j,0,*]^2+uvw[i,*,j,1,*]^2))
	uv=reform(uv,n_elements(uv))
	ve=scans[index].vissqcerr(i,0:genconfig.numspecchan[i]-1,j)
	k=where(reform(ve) gt 0,count)
;	Do not include baselines without data
	if count eq 0 then continue
	bl_max[j,i]=nint(max(uv[k]))
	bl_min[j,i]=nint(min(uv[k]))
endfor
endfor
;
; Determine baseline/triple configurations
configs=strarr(genconfig.numoutbeam)
for i=0,genconfig.numoutbeam-1 do begin
	baselines=genconfig.baselineid[*,i]
	j=where(baselines ne 'ST1-ST2',nj)
	baselines=baselines[j]
	if nj eq 3 then $
	configs[i]=strjoin(unique(nameparse(strjoin(baselines,'-'),'-')),'-') $
	else $
	configs[i]=baselines[j]
endfor
b_index=where(strlen(configs) eq  7,b_count)	; index into configs
t_index=where(strlen(configs) eq 11,t_count)	; index into configs
triangles=configs[t_index]
baselines=configs[b_index]
;
; Remove baselines which are part of triples
for i=0,n_elements(baselines)-1 do begin
	for j=0,n_elements(triangles)-1 do begin
		if strpos(triangles[j],baselines[i]) ge 0 or $
		   strpos(triangles[j],breve(baselines[i])) ge 0 $
		then baselines[i]=''
	endfor
endfor
;
; Check for triples on target without data
gc=genconfig
for i=0,t_count-1 do begin
	j=t_index[i]
	jndex=where(scans[index].triplephasecerr(j) gt 0,jcount)
	if jcount eq 0 then begin
;		triangles(t_index(i))=''
		triangles[i]=''
;		Check which baselines in this triple do have data
;		scans.vissq = array[#combiner,#channel,#baseline,[#scans]]
		baseids=genconfig.baselineid[*,j]
		for k=0,2 do begin
		k_index=where(scans[index].vissqcerr(gc.triplebeam[j],*,k) $
			gt 0,num_k)
		if num_k ge 1 then baselines=[baselines,baseids[k]]
		endfor
	endif
endfor
config=strtrim(strjoin(triangles,' ')+' '+strjoin(baselines,' '),2)
;
; Visibility errors for the requested target and its calibrators
index=where(scans.starid eq target and scantable.code eq 1,target_count)
if target_count gt 1 then $
	target_mask=total(scans[index].vissqcerr gt 0,4) $
else if target_count eq 1 then $
	target_mask=scans[index].vissqcerr gt 0
;
stars=startable.starid
nstars=n_elements(stars)
exist=intarr(nstars)
for i=0,nstars-1 do begin
	index=where(scans.starid eq stars[i] and scantable.code eq 1,count)
	if count gt 0 then begin
		if count gt 1 then $
			calib_mask=total(scans[index].vissqcerr gt 0,4) $
		else 	calib_mask=scans[index].vissqcerr gt 0
		if target_count gt 0 then $
			common_mask=(calib_mask*target_mask) gt 0 else $
			common_mask=calib_mask gt 0
		vissqcerr=scans[index].vissqcerr
		vissqe=scans[index].vissqe
		kndex=where(vissqe eq 0,kount)
		if kount gt 0 then vissqe[kndex]=1
		for j=0,count-1 do vissqcerr[*,*,*,j]= $
				   vissqcerr[*,*,*,j]*common_mask
		index=where(vissqcerr gt 0,count)
		if count gt 0 then exist[i]=exist[i]+1
	endif
endfor
;
; Print table
if strlen(config) ne 0 then printf,unit,utdate,num_scans,config,max(bl_max), $
	num_vis,num_triple, $
	format='(a,"&",i3,"&",a,"&",i3,"&",i4,"&",i3,"\\")'
;
; Restore copy of startable as it was modified in this procedure
startable=startable_bck
;
ENDFOR
;
IF aas THEN BEGIN
	printf,unit,'\enddata'
	printf,unit,'\end{deluxetable}'
ENDIF ELSE BEGIN
	printf,unit,'\hline'
	printf,unit,'\end{tabular}'
	printf,unit,'\end{table}'
ENDELSE
printf,unit,'\end{document}'
free_lun,unit
;
spawn,'sed -i {s/AC0/AC/g} '+obslog
spawn,'sed -i {s/AE0/AE/g} '+obslog
spawn,'sed -i {s/AW0/AW/g} '+obslog
spawn,'sed -i {s/W07/W7/g} '+obslog
spawn,'sed -i {s/E06/E6/g} '+obslog
;
end
