function omag,mt,m2
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute m1 (the "other mag") given a total magnitude and m2
;
ft=fltarr(n_elements(mt))
index=where(mt ne +100,count)
if count gt 0 then ft[index]=10.^(-mt[index]/2.5)
;
f2=fltarr(n_elements(m2))
index=where(m2 ne +100,count)
if count gt 0 then f2[index]=10.^(-m2[index]/2.5)
;
f1=ft-f2
mag=fltarr(n_elements(f1))+100
index=where(f1 gt 0,count)
if count gt 0 then mag[index]=-2.5*alog10(f1[index])
if count eq 1 then return,mag[0] else return,mag
;
end
