function omega2d,omega,tilt
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute sphericity D from rotational angular speed Omega in units of
; the breakup speed. According to Domiziano de Souza 2002 A&A 393, 345,
; (Omega/Omega_C)^2 = 27/4 (D^2-D^3), where D = R_p/R_eq, i.e. the flattening
; of a rotating star. Furthermore, (V_eq/V_C)^2 = 3 (1-D). In general,
; this function has to solve a cubic equation, for which in our case three
; solutions exist (y1,y2,y3). We use method 3 on page 184 of Bronstein and
; Semendjajew, but setting R = sqrt(abs(p)/3) instead to select the correct
; solution.
;
; Note that u in van Belle et al. 2005 is the same as Omega/Omega_C.
; According to Peterson et al. 2006, Omega_C^2=8/27 GM/R_P^3.
;
; Do a simple projection if tilt is specified.
; Tilt=0 is pole-on and implies D=1.
;
o=2*omega^2-1
p=-1./3
q=2*o/27
d=(p/3)^3-(q/2)^2
r=sqrt(abs(p)/3)
phi=acos(q/(2*r^3))
y1=-2*r*cos(phi/3)
y2=-2*r*cos(phi/3+2*!pi/3)
y3=-2*r*cos(phi/3+4*!pi/3)
;
; Sphericity = rp/re
s=y2+1./3
;
if n_elements(tilt) eq 0 then tilt=90
;
re=theta2r(0,omega)
rp=theta2r(tilt,omega)
s=rp/re
;
return,s
;
end
