function oneill,lambda,t,r,p
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return refractive index for air according to Owens, with input from the
; NPOI observerlog, i.e. t in Fahrenheit, r relative humidity in %, and
; p in inch Hg. Lambda in microns.
;
; Convert t into Celsius
t0=(t-32)*(5./9)
;
; Convert r into mb at sea level
temp=[-30.,-20,-10,0,10,20,30,40]			; Celsius
evap=[50.88,125.4,286.3,610.8,1227,2337,4243,7378]	; Pascal
e=(r/100)*interpol(evap,temp,t0)/100
;
; Convert e to height 2200 m, altitude of NPOI site
h=2.2	; km
e=e*10^(-h/2)
;
; Convert barometric pressure into mb
p0=33.8*p
;
return,owens(lambda,p0,t0,e)
;
end
