function opotentials,r,q,f,the=the,phi=phi
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute modified surface potentials according to Eq.1 of Wilson, 1979
; r is radius/semi-major axis, hence r <= 1
;
if n_elements(f) eq 0 then f=1.
if n_elements(q) eq 0 then q=1.
if n_elements(r) eq 0 then r=1.
;
if n_elements(the) eq 0 then the=0
if n_elements(phi) eq 0 then phi=0
;
d=1.
l=cos(the*!pi/180)
n=cos(phi*!pi/180)
;
return,1/r+q*((d^2+r^2-2*r*l*d^2)+0.5*f^2*(1+q)*r^2*(1-n^2))
;
end
