pro orbfuncs,jd,a,rmod,drda,ma,ndata,ia
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common FitEllipse,ex,ey
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
deltaa=dblarr(7)
deltaa[0]=0.1			; Major axis increment
deltaa[1]=0.02			; Eccentricity
deltaa[2]=0.02			; Inclination
deltaa[3]=0.005/(a[1]^2+0.005)	; Periastron
deltaa[4]=0.02/(sin(a[2])+0.02)	; Node
deltaa[5]=a[5]/1000		; Period
deltaa[6]=a[5]/1000		; Epoch
;
if n_elements(gen_model) ne 0 then begin
	ra=gen_model.ra
	dec=gen_model.dec
endif
;
drda=dblarr(ndata,ma)
;
b=a
;
for j=0,ma-1 do begin
	if ia[j] gt 0 then begin
		b[j]=a[j]-deltaa[j] & bb=[b[0:3],0,b[4:6]]
		xy=true2app(jd,bb,rho,theta,gen_model.ra,gen_model.dec)
		r_low=sqrt((xy[*,0]-ex)^2+(xy[*,1]-ey)^2)
		b[j]=a[j]+deltaa[j] & bb=[b[0:3],0,b[4:6]]
		xy=true2app(jd,bb,rho,theta,ra,dec)
		r_high=sqrt((xy[*,0]-ex)^2+(xy[*,1]-ey)^2)
		b[j]=a[j]
		drda[*,j]=(r_high-r_low)/(2*deltaa[j])
	endif
endfor
;
aa=[a[0:3],0,a[4:6]]
xy=true2app(jd,aa,rho,theta,gen_model.ra,gen_model.dec)
rmod=sqrt((xy[*,0]-ex)^2+(xy[*,1]-ey)^2)
;
end
