pro outliers,ns
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Flag outliers in large data sets, e.g. GRAVITY HR.
; Must have computed model values first.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if n_elements(ns) eq 0 then ns=20
;
if n_elements(gen_model) eq 0 then begin
	if n_elements(unique(scans.starid)) eq 1 then starid=scans[0].starid $
						 else begin
		print,'Error: No model and more than one star in StarTable!'
		return
	endelse
endif else starid=gen_model.starid
;
for i=0,genconfig.numoutbeam-1 do begin
for l=0,genconfig.numbaseline[i]-1 do begin
for k=0,n_elements(scans)-1 do begin
;
if scans[k].starid eq starid then begin
index=where(abs(( $
	scans[k].vissqc(i,0:genconfig.numspecchan[i]-1,l) $
       -scans[k].vissqm(i,0:genconfig.numspecchan[i]-1,l)) $
	/scans[k].vissqcerr(i,0:genconfig.numspecchan[i]-1,l)) gt ns and $
	 scans[k].vissqcerr(i,0:genconfig.numspecchan[i]-1,l) gt 0,count)
;
if count gt 0 then scans[k].vissqcerr(i,index,l) $
	     =-abs(scans[k].vissqcerr(i,index,l))
endif
;
endfor
endfor
endfor
;
for i=0,genconfig.numtriple-1 do begin
for k=0,n_elements(scans)-1 do begin
;
if scans[k].starid eq starid then begin
index=where(abs(( $
	scans[k].tripleampc(i,0:genconfig.triplenumchan[i]-1) $
       -scans[k].tripleampm(i,0:genconfig.triplenumchan[i]-1)) $
	/scans[k].tripleampcerr(i,0:genconfig.triplenumchan[i]-1)) gt ns and $
	 scans[k].tripleampcerr(i,0:genconfig.triplenumchan[i]-1) gt 0,count)
;
if count gt 0 then scans[k].tripleampcerr(i,index) $
	     =-abs(scans[k].tripleampcerr(i,index))
;
index=where(abs(( $
	scans[k].triplephasec(i,0:genconfig.triplenumchan[i]-1) $
       -scans[k].triplephasem(i,0:genconfig.triplenumchan[i]-1)) $
	/scans[k].triplephasecerr(i,0:genconfig.triplenumchan[i]-1)) gt ns and $
	 scans[k].triplephasecerr(i,0:genconfig.triplenumchan[i]-1) gt 0,count)
;
if count gt 0 then scans[k].triplephasecerr(i,index) $
		     =-abs(scans[k].triplephasecerr(i,index))
endif
;
endfor
endfor
;
;
end
