function owens,lambda,p,t,f
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return refractive index for air. lambda[mu], p[mb], t[C], f[mb]
; According to Owens, Appl. Opt. 6, 51 (1967)
; Note that hPa=mb!
;
if n_params() gt 0 and n_params() lt 4 then begin
	p=ppair(2635)		; mb
	t=12.d0      		; C
	f=ppwv(t,35)*p/1013.	; mb
endif
;
tk=t+273.15d0	; temperature in Kelvin
;
s=1.d0/lambda
a=(2372.434d0+684255.24d0/(130.d0-s^2)+4549.4d0/(38.9d0-s^2))
b=a-(6487.31d0+58.058d0*s^2-0.7115d0*s^4+0.08851d0*s^6)
n=(a*p-b*f)/tk
n=n*1d-8
;
return,n+1
;
end
