pro oyster
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Main widget procedure for OYSTER software.
;
common OysterWids,top_wid
;
if n_elements(top_wid) eq 0 then top_wid=0L
if top_wid ne 0 then begin
	print,'Widget already displayed!'
	return
endif
top_wid=widget_base(title='oisdr',resource_name='oyster',/column, $
	kill_notify='ww_quit', $
	xoffset=1,yoffset=1)
;
button_wid=widget_button(top_wid,event_pro='ww_oyster',uvalue='Help', $
	/bitmap,value=!oyster_dir+'oisdr.bmp',/frame)
row_wid=widget_base(top_wid,/row)	; optional
chameleon_wid=widget_base(top_wid,/column,/frame,/base_align_center)
amoeba_wid=widget_base(top_wid,/column,/frame,/base_align_center)
; oyster_wid=widget_base(top_wid,/column,/frame,/base_align_center)
;
; CHAMELEON panel
file_menu=[ $
	'1\File\ww_file', $
			'0\OPEN', $
			'0\Close', $
			'2\ClrSt' $
	]
access_menu=[ $
	'1\Access\ww_access', $
			'0\Tree', $
			'0\BROWSE', $
			'1\Load\ww_access', $
					'0\INTERFEROMETRY', $
					'2\METROLOGY', $
			'1\Write\ww_write', $
					'0\HDS', $
					'0\XDR', $
					'0\OI-FITS', $
					'2\UV-FITS' $
	]
reduce_menu=[ $
	'1\Reduce\ww_reduce', $
			'1\BG Data\ww_reducebg', $
				'0\PLOT', $
				'0\Process BG', $
				'0\Median BG', $
				'0\Expand BG', $
				'0\Default BG', $
				'7\Flagtable\ww_reducebg', $
						'0\Save', $
						'0\Load', $
						'0\Apply', $
						'0\Clear', $
						'4\UNFLAG', $
						'2\Reset', $
			'1\Point Data', $
				'1\Imaging\ww_reducept', $
					'0\PLOT', $
					'0\Unwrap triple', $
					'2\Clear bias', $
				'1\Astrometry\ww_reducedl', $
					'0\PLOT', $
					'0\Init', $
					'0\InitW', $
					'0\PhaseEdit', $
					'0\PhaseWrap', $
					'2\DispCorr', $
				'7\Flagtable\ww_reducept', $
						'0\Save', $
						'0\Load', $
						'0\Apply', $
						'0\Clear', $
						'4\UNFLAG', $
						'2\Reset', $
			'1\Inch Data\ww_reducemt', $
				'0\PLOT', $
				'0\Init', $
				'0\MetroCorr', $
				'0\AstroCorr', $
				'7\Flagtable\ww_reducemt', $
						'0\Save', $
						'0\Load', $
						'0\Apply', $
						'0\Clear', $
						'4\UNFLAG', $
						'2\Reset', $
			'6\Average' $
	]
calibrate_menu=[ $
	'1\Calibrate\ww_calibrate', $
			'0\SEEING', $
			'0\SYSTEM', $
			'0\PHOTOMETRY', $
			'1\Visibility\ww_scans', $
					'0\PLOT', $
					'0\CALIBRATE', $
					'0\FlagIncoh', $
					'0\SetErrors', $
					'0\SetComplex', $
					'3\Triple\ww_scans', $
							'0\RewrapTriple', $
							'0\DewrapTriple', $
							'2\ManualUnwrap', $
			'1\Astrometry\ww_astrom', $
					'0\PLOT', $
					'0\Calc', $
					'0\MCorr', $
					'2\SOLVE', $
			'7\Flagtable\ww_scans', $
					'0\Save', $
					'0\Load', $
					'0\Apply', $
					'0\Clear', $
					'4\UNFLAG', $
					'2\Reset' $
	]
utilities_menu=[ $
	'1\Utilities\ww_utilities', $
			'0\MEMO', $
			'0\OBSBASE', $
			'0\.CAL->.CHA', $
			'0\.CHA->.OIFITS', $
			'0\Load Night', $
			'0\Load StarTable', $
			'1\List\ww_utilities', $
					'0\Summary', $
					'0\Stars', $
					'0\Scans', $
					'0\BGScans', $
					'4\ScnLog', $
					'0\ObsLog', $
					'0\ConLog', $
					'4\STARS', $
					'2\Star', $
			'3\Forms\ww_utilities', $
					'0\ScanForms', $
					'2\SpecForms' $
	]
;
file_wid=cw_pdmenu(chameleon_wid,file_menu)
access_wid=cw_pdmenu(chameleon_wid,access_menu)
reduce_wid=cw_pdmenu(chameleon_wid,reduce_menu)
calibrate_wid=cw_pdmenu(chameleon_wid,calibrate_menu)
utilities_wid=cw_pdmenu(chameleon_wid,utilities_menu)
;
; AMOEBA panel
data_menu=[ $
	'1\Data\ww_amoebadata', $
			'0\INTERFEROMETRY', $
			'0\ASTROMETRY', $
			'0\SPECTROSCOPY', $
			'0\PHOTOMETRY', $
			'6\Summary' $
	]
model_menu=[ $
	'1\Model\ww_amoebamodel', $
			'0\READ', $
			'0\Info', $
			'0\Calc', $
			'6\FIT' $
	]
plot_menu=[ $
	'1\Plot\ww_amoebaplot', $
			'1\Interferometry\ww_amoebaplot', $
				'0\UV Plots', $
				'0\XY Plots', $
				'2\Astrometry', $
			'0\ASTROMETRY', $
			'0\SPECTROSCOPY', $
			'2\PHOTOMETRY' $
	]
fit_menu=[ $
	'1\Fit\ww_amoebafit', $
			'0\ASTROMETRY', $
			'0\INTERFEROMETRY', $
			'6\CONTROL' $
	]
astrometry_menu=[ $
	'1\Astrometry\ww_volvox', $
			'0\Plot', $
			'0\Calc', $
			'0\MCorr', $
			'0\WCorr', $
			'0\Get PMs', $
			'0\Get HIP', $
			'6\SOLVE' $
	]
;
data_wid=cw_pdmenu(amoeba_wid,data_menu)
model_wid=cw_pdmenu(amoeba_wid,model_menu)
plot_wid=cw_pdmenu(amoeba_wid,plot_menu)
fit_wid=cw_pdmenu(amoeba_wid,fit_menu)
astrometry_wid=cw_pdmenu(amoeba_wid,astrometry_menu)
;
; OYSTER panel
oyster_menu=[ $
	'1\OYSTER\ww_oyster', $
			'0\Help', $
			'0\Save session', $
			'0\Restore session', $
			'0\Help,/memory', $
			'2\Exit widget' $
	]
;
; Display main widget
widget_control,top_wid,/realize
xmanager,'oyster',top_wid,/no_block
;
; Set the screen size variables
r=get_screen_size()
!dxsize=r[0]
!dysize=r[1]
;
end
