function oyster_starid,starids,quiet=quiet
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This function is called to allow the creation of the OYSTER StarTable with
; StarIDs not following the OYSTER standard, e.g., HD 123456 -> HDN123456
;
for i=0l,n_elements(starids)-1 do begin
	starids[i]=strcompress(starids[i],/remove_all)
	ok=0
	case strmid(starids[i],0,3) of
	'HDN': ok=1
	'HIP': ok=1
	'BSC': ok=1
	'FKV': ok=1
	'USR': ok=1
	 else:
	endcase
	if not ok then begin
	case strmid(starids[i],0,2) of
	'HD': starids[i]='HDN'+string(strmid(starids[i],2,6),format='(i6.6)')
	'HI': starids[i]='HIP'+string(strmid(starids[i],2,6),format='(i6.6)')
	'HR': starids[i]='BSC'+string(strmid(starids[i],2,4),format='(i4.4)')
	'FK': starids[i]='FKV'+string(strmid(starids[i],3,4),format='(i4.4)')
	else: if not keyword_set(quiet) then print,'Unknown StarID '+starids[i] $
		+'! Please add in oyster/starbase/vlti.hdn.'
	endcase
	endif
endfor
;
return,starids
;
end
