function packetdir,filename
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return packet directory for NPOI raw file.
; Also set the var_num fields which contain important packet
; dimensioning information.
;
common PacketData,pd_all,var_num,packet
;
rawfile=filename
;
maxdirent=40000l
;
pd_record={file:rawfile,day:0l,time:0l,type:0l,length:0l,offset:0l}
pd=replicate(pd_record,maxdirent)
;
day=pd.day
time=pd.time
type=pd.type
length=pd.length
offset=pd.offset
;
status=linknload(!external_lib,'scandisk', $
	rawfile,day,time,type,length,offset,maxdirent)
if status ne 0 then return,0
;
pd.day=day
pd.time=time
pd.type=type
pd.length=length
pd.offset=offset
;
pd=pd[where(pd.length gt 0)]
pd=pd[where(strlen(packettype(pd.type)) gt 0)]
openr,unit,rawfile,/get_lun
r=fstat(unit)
if long(total(pd.length)) gt r.size then pd=pd[0:n_elements(pd)-2]
free_lun,unit
;
; Set packet dimensioning info
index=where(pd.type eq '00000000'X,count)
if count gt 0 then begin
	p=readpacket(pd[index[0]])
	parsedate,p.body.date,y,m,d
	if julian(y,m,d) lt julian(2001,9,28) $
		then var_num={sid:6l,fdl:6l,spec:3l,bin:8l,chan:32l,rec:500l} $
		else var_num={sid:6l,fdl:6l,spec:2l,bin:64l,chan:16l,rec:500l}
;	These files have the wrong date
	if julian(y,m,d) ge 2001-01-08 and julian(y,m,d) le 2001-01-12 then $
		     var_num={sid:6l,fdl:6l,spec:2l,bin:64l,chan:16l,rec:500l}
endif
;
return,pd
;
end
