pro packetlist,rawfilespec
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common PacketData,pd_all,var_num,packet
common PacketWids,listscan_wid,listpack_wid
;
if n_elements(rawfilespec) eq 1 then rawfiles=findfile(rawfilespec) $
				else rawfiles=rawfilespec
index=where(strpos(rawfiles,'fringeData') ne -1 $
         or strpos(rawfiles,'alignData') ne -1,count)
if count eq 0 then begin
	print,'***Error(NAVIGATOR): no valid files!'
	return
endif
rawfiles=rawfiles[index]
base_wid=widget_base(/row,title=strmid(rawfilespec[0],0,9)+'* (packetlist)', $
	resource_name='oyster')
col1_wid=widget_base(base_wid,/col)
for i=0,n_elements(rawfiles)-1 do begin
	pd=packetdir(rawfiles[i])
	if i eq 0 then pd_all=pd else pd_all=[pd_all,pd]
	text_wid=widget_text(col1_wid,value=rawfiles[i])
	list_wid=widget_list(col1_wid,event_pro='packetlist_event', $
		value=packettype(pd.type),ysize=10)
	widget_control,list_wid,set_uvalue=pd
endfor
;
col2_wid=widget_base(base_wid,/col)
index=where(packettype(pd_all.type) eq 'SCAN_START_VERSION_1',count)
if count gt 0 then begin
	stars=strarr(count)
	for i=0,count-1 do begin
		p=readpacket(pd_all[index[i]])
		stars[i]=p.body.starid
	endfor
	liststar_wid=widget_list(col2_wid,event_pro='starlist_event', $
		value=unique(stars),uvalue=unique(stars),ysize=6,/multiple)
	listscan_wid=widget_list(col2_wid,event_pro='scanlist_event', $
		value=' ',ysize=10)
	listpack_wid=widget_list(col2_wid,event_pro='packetlist_event', $
		value=' ',ysize=10,xsize=max(strlen(packettype(pd_all.type)))+1)
	widget_control,listpack_wid,set_uvalue=pd
endif
widget_control,base_wid,/realize
xmanager,'packetlist',base_wid,/no_block
;
end
