pro packetlist_event,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Callback procedure for when user clicks on a packet. Reads packet and
; performs courtesy operations/storage.
;
common PacketData,pd_all,var_num,packet
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
widget_control,event.id,get_uvalue=pd
index=where(pd_all.time eq pd[event.index].time $
        and pd_all.type eq pd[event.index].type)
jndex=where(pd_all.file eq pd[event.index].file)
print,'Reading packet No. '+string(index-jndex[0]+1,format='(i5)') $
		+' in file '+pd[event.index].file
print,'Header time stamp is '+hms(pd[event.index].time/3600000.0)
packet=readpacket(pd[event.index])
;
case pd[event.index].type of
;		     FILE_HEADER
	'00000000'X: begin
		     print,'File date: ',packet.body.date
		     Date=packet.body.date
		     end
;		     SCAN_START_VERSION_1
	'000b0000'X: print,'Scan '+string(packet.body.scanid)+' Star: '+packet.body.sta
;		     FDL_POSITION
	'000e0001'X: begin
		     set_screen
		     if n_elements(genconfig) ne 0 then begin
			numsid=genconfig.numsid
		     	labels=genconfig.stationid
			delays=packet.body.laserpath[genconfig.delaylineid-1,*]
			if genconfig.refstation ge 1 then begin
			for i=0,numsid-1 do $
				if i ne genconfig.refstation-1 then $
				delays[i,*]=delays[i,*]-delays[genconfig.refstation-1,*]
			delays[genconfig.refstation-1,*]=0
			ytitle=' Delay'
			endif else ytitle=' Path'
		     endif else begin
			numsid=6
		     	labels=strarr(numsid)
			delays=packet.body.laserpath
			ytitle=' Path'
		     endelse
		     !p.multi=[0,1,numsid]
		     !p.charsize=2.0
		     !y.title=ytitle+' [mu]'
		     time=double(packet.body.timestamp)/3600000l
		     time0=hms(time[0]) & time=(time-time[0])*3600
		     !x.title='Time [s] - '+time0
		     for i=0,numsid-1 do $
			plot,time,polyres(time,delays[i,*],1)*1e6, $
			ymargin=[3,1],ytitle=labels[i]+!y.title,psym=3
		     end
;		     FRINGE_DATA_VERSION_1
;	'000c0001'X: fringemovie,packet.body.bincounts
	'000c0001'X: begin
		     numout=3
		     if n_elements(genconfig) ne 0 then numout=genconfig.numoutbeam
		     !p.multi=[0,1,numout]
		     for i=0,numout-1 do fringespectrum,packet.body.bincounts[i,*,[0,1,2,3,4],
		     end
;		     FRINGE_BG
;	'000c0004'X: fringemovie,packet.body.bincounts
	'000c0004'X: begin
		     numout=2
		     if n_elements(genconfig) ne 0 then numout=genconfig.numoutbeam
		     !p.multi=[0,1,numout]
		     for i=0,numout-1 do fringespectrum,packet.body.bincounts[i,*,0,*]
		     end
;		     FRINGE_DARK
	'000c0005'X: print,packet.body.rate
;		     NAT_COUNTS
	'000d0001'X: begin
		     plot_benhist,counts=float(packet.body.quadcounts)
		     print,'Mean fluxes:'
		     print,natmfluxes(packet.body.quadcounts)
		     end
;		     SYS_CONFIG
	'000a0000'X: begin
		     geoparms=packet.body.geoparms
		     genconfig=packet.body.genconfig
		     systemid=packet.body.systemid
		     list_summary_chameleon
		     end
	else:
endcase
;
end
