function packettype,type
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Translate packet types and return their names.
;
result=strarr(n_elements(type))
;
types=[ $
['FILE_HEADER','0x00000000'], $
['PACKET_SYMBOL_TABLE','0x00010000'], $
['PACKET_DIRECTORY','0x00010001'], $
['PAD','0x00020000'], $
['END_OF_DISK','0x00030000'], $
['END_OF_SESSION','0x00030001'], $
['SYS_CONFIG','0x000a0000'], $
['SYS_LOG','0x000a0001'], $
['SCAN_START_VERSION_1','0x000b0000'], $
['STAR_ACQUIRED','0x000b0001'], $
['SCAN_START_VERSION_2','0x000b0002'], $
['SCAN_END','0x000b0003'], $
['SCAN_OPERATOR_COMMENT','0x000b0004'], $
['FRINGE_DATA_VERSION_1','0x000c0001'], $
['FRINGE_DATA_VERSION_2','0x000c0002'], $
['FRINGE_BG','0x000c0004'], $
['FRINGE_DARK','0x000c0005'], $
['FRINGECON_SERVO_PARAMS','0x000c0006'], $
['NAT_COUNTS','0x000d0001'], $
['NAT_PIEZO_SIGNAL','0x000d0002'], $
['NAT_BG','0x000d0003'], $
['NAT_DARK','0x000d0004'], $
['NAT_SERVO_PARAMS','0x000d0005'], $
['FDL_POSITION','0x000e0001'], $
['FDL_JITTER','0x000e0002'], $
['FDL_STATUS','0x000e0003'], $
['METRO_DATA','0x000f0001'], $
['METRO_CONFIG','0x000f0002'], $
['WASA_IMAGE','0x00110001'], $
['SID_MOTOR_COUNTS','0x00110002'], $
['SID_MODEL','0x00110003'], $
['SYNC','0x0e100f09'] $
]
;
for i=0,n_elements(types[0,*])-1 do begin
	status=execute("t='"+strmid(types[1,i],2,8)+"'X")
	index=where(type eq t,count)
	if count gt 0 then result[index]=types[0,i]
endfor
;
return,result
;
end
