function parallacticangle,ha,dec
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return parallactic angle in degrees. Input HA is in hours, DEC in degrees.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
rad=180/pi_circle
ha_r=ha*(15/rad)
dec_r=dec/rad
tanq=sin(ha_r)/(tan(GeoParms.Latitude/rad)*cos(dec_r)-sin(dec_r)*cos(ha_r))
return,atan(tanq)*rad
;
end
