pro parsedate,date,y,m,d,h
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Extracts year, month, and day (long integers) from CONSTRICTOR format.
; date string (e.g.: 1994-05-31). Optionally return hours in h if single date
; string has fractional day.
;
y=long(strmid(date,0,4))
m=long(strmid(date,5,2))
d=long(strmid(date,8,2))
h=0.0
;
; Add a test using STRTRIM to remove trailing blanks from date.
; If the STRLEN after removal of trailing blanks > 10 then a
; fractional day number is present.
;
if n_elements(date) eq 1 and strlen(strtrim(date[0])) gt 10 then begin
	h=float(strmid(date,10,strlen(date)-10))*24
endif
;
end
