pro parseidldate,idl_date,y,m,d
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Extracts year, month, and day (long integers) from IDL date,
; e.g. Mon Oct 27 17:17:13 2003. If called with just 2 arguments,
; return date/time string in variable y.
;
; Array input OK.
;
months=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']
;
y=long(strmid(idl_date,20,4))
;
n=n_elements(idl_date)
m=lonarr(n)
for i=0L,n-1 do m[i]=where(months eq strmid(idl_date[i],4,3),count)+1
;
d=long(strmid(idl_date,8,2))
;
if n_params() eq 2 then begin
	time=strmid(idl_date,11,8)
	date=string(y)+'-'+string(m)+'-'+string(d)+'T'+strmid(idl_date,11,8)
	y=strcompress(date,/remove_all)
endif
if n_elements(idl_date) eq 1 then m=m[0]
;
end
