pro pearl,starid,cellsize=cellsize,imsize=imsize,lmin=lmin,lmax=lmax
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Setup and start an imaging session.
; Cellsize [mas], imsize=[nx,ny] or imsize=nxy (square map)
;
; lmin/lmax are the minimum and maximum wavelength [nm] to use.
; If lmax < lmin, take these values as center and width [nm].
;
common PearlWids,draw_wid,clean_wid,channel_wid
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
common PearlBoxes,clbox_x,clbox_y,ncl,crbox_x,crbox_y,ncr
common LocalPearl,star,pearl_channel
common LocalClean,rmmaps,ccmaps,niter,niter_total
;
if n_elements(lmin) eq 0 then lmin=100.		; [nm]
if n_elements(lmax) eq 0 then lmax=100000.	; [nm]
flag=0
if lmin lt 100 then flag=1
if lmax lt 100 then flag=1
if flag then begin
	print,'Error: lmin and lmax should be in [nm]!'
	return
endif
lmin=float(lmin)
lmax=float(lmax)
if lmax lt lmin then begin
	lmin=lmin-lmax/2
	lmax=lmin+lmax
endif
;
; Initialize imaging data
pearldata,starid,status,lmin=lmin,lmax=lmax
if status ne 0 then return
niter_total=intarr(n_elements(unique(ci))+1)
;
; Initialize map parameters
uvr=sqrt(uc^2+vc^2)
fringespacing_min=(180/!pi)*3600000/max(uvr)
skip_cb=0
if n_elements(cellsize) eq 0 then begin
	cellsize=fringespacing_min/4
	print,'Cellsize [mas] set to: ',cellsize
endif else begin
	if cellsize gt fringespacing_min/3 then begin
	print,'Warning: cellsize too large!'
	skip_cb=1
	aparm=[fringespacing_min,fringespacing_min,0]
aparm=[20,20,0]
;	return
	endif
endelse
fringespacing_max=(180/!pi)*3600000/min(uvr[where(uvr ne 0)])
if n_elements(imsize) eq 0 then begin
	imsize=(4*fringespacing_max)/cellsize
	imsize=fix(imsize/2)*2+1
endif
if n_elements(imsize) eq 1 then imsize=[imsize,imsize]
if (imsize[0] mod 2) eq 0 then begin
	imsize[0]=imsize[0]+1
	print,'Warning(PEARL): imsize[0] must be odd, set to: ',imsize[0]
endif
if (imsize[1] mod 2) eq 0 then begin
	imsize[1]=imsize[1]+1
	print,'Warning(PEARL): imsize[1] must be odd, set to: ',imsize[1]
endif
print,'Mapsize is ',imsize[0]*cellsize,' mas by ',imsize[1]*cellsize,' mas'
dmsize=imsize
dbsize=imsize*2-1
;
; Compute maps
uci=unique(ci)
nc=n_elements(uci)
db=pearlimage(dbsize,cellsize,nc+1)	; 0: white light, 1-nc: channels
cb=pearlimage(dbsize,cellsize,nc+1)	; 0: white light, 1-nc: channels
;
print,'Computing dirty beam in '+string(nc,format='(i0)')+' channels...'
cv_1=cv & cv_1[*]=1
for j=0,nc-1 do begin
	index=where(ci eq uci[j])
	db=dft(db,cv_1[index],uc[index],vc[index],j+1,/db)
endfor
db.maps.map=db.maps.map/nc
db.maps[0].map=total(db.maps.map,3)		; white light dirty beam
status=set_scales(db)
if skip_cb then cb=cleankernels(db,aparms=aparm) $
	   else cb=cleankernels(db)		; clean beam
;
print,'Computing white light dirty map...'
dm=pearlimage(dmsize,cellsize,nc+1)
rm=dm
dirtymap
;
cm=pearlimage(dmsize,cellsize,nc+1)	; clean map
cc=cm					; clean component map
;
; Inititalize regions and effective temperature map
pearlinit
;
base_wid=widget_base(/row,title='Pearl',resource_name='oyster', $
	kill_notify='pearlquit')
column1_wid=widget_base(base_wid,/col,event_func='clean_event')
column2_wid=widget_base(base_wid,/col,event_func='pearl_event')
;
draw_wid=widget_draw(column1_wid, $
        scr_ysize=dbsize[1]+1,scr_xsize=dbsize[0]+dmsize[0])
color_wid=widget_draw(column1_wid, $
        scr_ysize=30,scr_xsize=256)
row1_wid=widget_base(column1_wid,/row,/base_align_bottom)
clean_wid=cw_fslider(row1_wid,minimum=0,maximum=100,value=0,/drag, $
        xsize=dbsize[0],format='(i3)')
button_wid=cw_bgroup(row1_wid,/row,['Take','Update','Cycle','Help'], $
	/return_name)
channel_wid=widget_slider(column1_wid,minimum=0,maximum=nc,value=0,/drag, $
        xsize=dbsize[0]+dmsize[0],title='Channel slider (0=white light)')
button_wid=cw_bgroup(column1_wid,/row,/return_name, $
	['Remove','Clean','Contour','Calibrate','T-Map','T-Init','HELP'])
;
pearl_channel=0	; Initialize to white light channel
;
; Right-hand column of buttons
buttons=['Layout','Reset','Remove','Window','Regions','Selfcal','Shift', $
	 'Contour','Convolve','Save','Read','Clear','HELP']
button_wid=cw_bgroup(column2_wid,/col,buttons,/return_name)
;
widget_control,base_wid,/realize
xmanager,'pearl',base_wid,/no_block
;
; For now, PEARL uses color maps only
device,decomposed=0
;
; Display Teff color bar
bar = reverse(BINDGEN(256)) # REPLICATE(1B, 30)
loadct,13,/silent
tv,bar
tek_color
xyouts,1*256/5-!d.x_ch_size,!d.y_ch_size,'2K',/device,color=5
xyouts,2*256/5-!d.x_ch_size,!d.y_ch_size,'4K',/device,color=1
xyouts,3*256/5-!d.x_ch_size,!d.y_ch_size,'6K',/device,color=1
xyouts,4*256/5-!d.x_ch_size,!d.y_ch_size,'8K',/device,color=1
loadct,0,/silent
;
tvdb	; dirty beam (left)
tvrm	; residual map (upper right)
tvfm	; final map (lower right)
;
end
