function pearl_event,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Call back for the main Pearl GUI.
;
forward_function set_boxes
;
common LocalPearl,star,pearl_channel
common PearlWids,draw_wid,clean_wid,channel_wid
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
common PearlBoxes,clbox_x,clbox_y,ncl,crbox_x,crbox_y,ncr
common LocalClean,rmmaps,ccmaps,niter,niter_total
;
ch=pearl_channel
nc=n_elements(db.maps)
;
if n_elements(niter_total) eq 0 $
then niter_total=intarr(n_elements(unique(ci))+1)
if n_elements(ccmaps) eq 0 then $
	ccmaps=replicate({map:cc.maps[ch].map*0},1)
;
cellsize=db.x[0]-db.x[1]
dbxsize=n_elements(db.maps[ch].map(*,0))
dbysize=n_elements(db.maps[ch].map(0,*))
dmxsize=n_elements(dm.maps[ch].map(*,0))
dmysize=n_elements(dm.maps[ch].map(0,*))
;
command=event.value
case command of
	'Layout':begin
		print,'Large box left: DB, small upper box: FM, lower: RM/Tmap'
		end
	'Reset':begin
		print,'Resetting data and maps...',format='(a,$)'
		cv=ov
		mv=ov*0
		niter=0
;
		niter_total[*]=0
		cc.maps.map=0
		cm.maps.map=0
		rm.maps.map=0
		dirtymap
		tvfm
		tvrm
		tvcm
	       	widget_control,clean_wid,set_value=0
		ccmaps.map=0
		print,'done.'
		end
	'Remove':begin
		print,'Removing clean components from combined map...',format='(a,$)'
		cc.maps[0].map=0
		cm.maps[0].map=0
		rm.maps[0].map=0
		dirtymap
		tvfm
		tvrm
		tvcm
		ccmaps.map=0
		print,'done.'
		end
	'Window':begin
		print,'----------------------------------------------------'
		print,'Place one window in final map; right click to reset!'
		widget_control,draw_wid,get_value=win_num & wset,win_num
		!x.s=[0,1] & !y.s=[0,1] ; Normalized coordinates: (0,0)=BLC
		icom=set_boxes(x0,y0)
		if icom eq 4 then begin
;			Remove all windows, do not initialize Teff map!
			ncl=0
			icom=set_boxes(x0,y0,/clear)
			tvfm
			tvrm
			print,'Windows removed.'
			return,0
		endif
		xsize=dbxsize+dmxsize
		ysize=dmysize*2
;		(x,y) in map pixels
		x=(x0*xsize-dbxsize) > 0
		y=(y0*ysize-dmysize) > 0
		if total(x) eq 0 or total(y) eq 0 then begin
;			print,'***Error: window placed outside FM!'
;			return,-1
;			Assume it was placed in CM, move up to FM
			y0=y0+float(dmysize)/ysize
			y=(y0*ysize-dmysize) > 0
		endif
		r=size(cc.maps[0].map)
;		Make sure the box does not extend over the borders
		x=x>0
		x=x<r[1]
		y=y>0
		y=y<r[2]
		icom=cw_form('0,LIST,Window only|Window with Teff|Cancel,set_value=0,QUIT')
		case icom.tag0 of
;			  Setting a window
			0:begin
			  clbox_x[*,ncl]=x[*,0]
			  clbox_y[*,ncl]=y[*,0]
			  ncl=ncl+1
			  widget_control,clean_wid,/sensitive
			  tvcl
			  end
;			  Defining a region
		 	1:begin
			  clbox_x[*,ncl]=x[*,0]
			  clbox_y[*,ncl]=y[*,0]
			  ncl=ncl+1
			  read,teff,prompt='Enter Teff [K]: '
			  logg=4.5
			  cm.teff[x[0,0]:x[1,0],y[3,0]:y[4,0]]=teff
			  cm.logg[x[0,0]:x[1,0],y[3,0]:y[4,0]]=logg
			  cc.teff=cm.teff
			  cc.logg=cm.logg
			  rt[ncr]=teff
			  rg[ncr]=logg
			  index=unique(ci)-1
			  rf[*,ncr]=pearlflux(teff,wl[index],bw[index])
;			  Normalize rf with total flux
			  rf[*,ncr]=rf[*,ncr]/fl[index]
; 			  Scale with geometric mean
			  rf=rf/gavg(rf[*,0:ncr-1])
			  ncr=ncr+1
			  tvcl
			  end
			2:begin
			  icom=set_boxes(x0,y0,/clear)
			  end
		endcase
		print,'Number of active regions: ',ncr
		print,'Number of active windows: ',ncl
		end
	'Regions':begin
		etrg
		end
;	CLEAN window (currently not used, functionality included in Region)
	'Window_old':begin
		widget_control,draw_wid,get_value=win_num & wset,win_num
		!x.s=[0,1] & !y.s=[0,1] ; Normalized coordinates, (0,0)=BLC
		icom=set_boxes(x0,y0,n)
		xsize=dbxsize+dmxsize
		ysize=dmysize*2
;		(x,y) in map pixels
		x=(x0*xsize-dbxsize)
		y=(y0*ysize)
		icom=cw_form('0,LIST,Keep new windows|Keep old windows|Remove windows,set_valu
		case icom.tag0 of
		 	0:begin
			  clbox_x=x
			  clbox_y=y
			  ncl=n
			  end
			1:
			2:begin
			  ncl=0
			  icom=set_boxes(x0,y0,n,/clear)
			  end
		endcase
		print,'Number of active windows: ',ncl
		end
	'Selfcal':begin
		selfcal
		dirtymap
                tvrm,ch
		tvcm,ch
;               tvfm,ch
		print,'Display updated.'
		end
	'Scramble':begin
		scramblemap
		r=set_scale(rm,ch)
                tvrm,ch
		tvcm,ch
;               tvfm,ch
		print,'Display updated.'
		end
	'Shift':begin
;		Execute "Take" command
		status=clean_event({value:'Take'})
;		Now get shift vector
		read,x,y,prompt='Enter shift [mas] (right, up): '
		mas2rad=!pi/(180l*3600000l)
		i=fix(x*mas2rad/cellsize)
		j=fix(y*mas2rad/cellsize)
		for k=0,nc-1 do begin
		 	cm.maps[k].map=shift(cm.maps[k].map,i,j)
		 	rm.maps[k].map=shift(rm.maps[k].map,i,j)
		 	dm.maps[k].map=shift(dm.maps[k].map,i,j)
			cm.teff=shift(cm.teff,i,j)
			cc.teff=shift(cc.teff,i,j)
		endfor
		tvrm,ch
		tvcm,ch
		tvfm,ch
		x=i*cellsize
		y=j*cellsize
		p=2*!pi*(-uc*x+vc*y)
		cv[*]=cv*complex(cos(p),sin(p))
		mv[*]=mv*complex(cos(p),sin(p))
		end
	'Contour':begin
		if !d.name ne 'PS' then window,/free,xsize=550,ysize=500
		if ch ge 1 then $
		!p.title=star+' map for channel '+string(ch,format='(i2)') $
		else $
		!p.title=star+' CLEAN map'
		if !d.name eq 'PS' then device,filename=star+'.ps'
		tkpm,ch
		if !d.name eq 'PS' then begin
			device,/close
;			set_plot,!display
			set_screen
			print,'Plot saved in '+star+'.ps'
		endif
		widget_control,draw_wid,get_value=id
		wset,id
		device,decompose=0
		end
	'Convolve':begin
		cb0=cb
		read,a,b,p,prompt='Enter a,b[mas], pa[deg]: '
		if b gt a then begin
			print,'Minor axis must be shortar than major axis!'
		endif else begin
		 	cb=cleankernel(db,ch,aparms=[a,b,p])
;		 	tvfm
			tkfm
		 	cb=cb0
		endelse
		end
	'Save': begin
		fitsfile='pearl.fits'
		mas2rad=180/!pi*3600000.d0
		naxis1=dmxsize
		naxis2=dmysize
		parseidldate,systime(),y,m,d
		datum=constrictordate(y,m,d)
		cdelt1=cellsize
		cdelt2=cellsize
		header=["SIMPLE  =                    T / Written by IDL", $
		         "BITPIX  =                  -32 / Number of bits per data pixel", $
		         "NAXIS   =                    2 / Number of data axes", $
		         "NAXIS1  =   "+string(naxis1)+" /", $
        		 "NAXIS2  =   "+string(naxis2)+" /", $
        		 "EXTEND  =                    T / FITS data may contain extensions",
        		 "DATE    = '"+datum+"'         / Creation date of FITS header", $
        		 "BSCALE  =    1.00000000000E+00 /REAL = TAPE * BSCALE + BZERO", $
        		 "BZERO   =    0.00000000000E+00 /", $
        		 "CTYPE1  = 'RA---TAN'           /", $
        		 "CRVAL1  =    0.00000000000E+00 /", $
        		 "CDELT1  =   "+string(cdelt1)+" / radians", $
        		 "CRPIX1  =      1.000000000E+00 /", $
        		 "CROTA1  =      0.000000000E+00 /", $
        		 "CTYPE2  = 'DEC--TAN'           /", $
        		 "CRVAL2  =    0.00000000000E+00 /", $
        		 "CDELT2  =   "+string(cdelt2)+" / radians", $
        		 "CRPIX2  =      1.000000000E+00 /", $
        		 "CROTA2  =      0.000000000E+00 /", $
        		 "END     "]
		writefits,fitsfile,cm.maps[0].map+cc.maps[0].map,header
	        ext_header=["XTENSION= 'IMAGE' / IMAGE extension", $
	                     "BITPIX  = -32 /  Number of bits per data pixel", $
	                     "NAXIS   = 2 / Number of data axes", $
	                     "NAXIS1  = "+string(naxis1)+" /", $
	                     "NAXIS2  = "+string(naxis2)+" /", $
	                     "PCOUNT  = 0 / No Group Parameters", $
	                     "GCOUNT  = 1 / One Data Group", $
	                     "EXTNAME = 'Teff' /", $
	                     "END     "]
	        writefits,fitsfile,cm.teff,ext_header,/append
	        ext_header[where(strpos(ext_header,'EXTNAME') ge 0)] $
			="EXTNAME = 'log(g)' /"
	        writefits,fitsfile,cm.logg,ext_header,/append
		print,'Saved to file '+fitsfile
		end
	'Read':	begin
		readimage,'pearl.fits'
		pearlinit,cm.teff
		residualmap
		tvfm
		tvrm
		tvcm
		end
	'Clear':begin
		set_screen
		device,decompose=0
		wdall
		end
	'HELP':	begin
		print,'Layout: click to have explanation of maps'
		print,'Reset: start over, but keep the windows'
		print,'Remove: remove all clean components from combined map'
		print,'Window: place or remove windows, optionally assign Teff'
		print,'Regions: draw irregularly-shaped region and assign Teff'
		print,'Selfcal: run phase self-calibration, display FM and DM/CM'
;		print,'Scramble: scramble observed phases (for testing purposes)'
		print,'Shift: shift map'
		print,'Contour: plot a contour PEARL map for the selected channel'
		print,'Convolve: convolve selected clean map with Gaussian'
		print,'Save: write PEARL map to disk (pearl.fits)'
		print,'Read: read PEARL map from disk (pearl.fits)'
		print,'Clear: remove all plot windows'
		end
endcase
;
end
