pro pearldata,starid,status,lmin=lmin,lmax=lmax
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Initialize imaging data, but not maps.
;
; Combines several data sets, but they all have to have
; the same spectrometer setup.
;
; ov: observed (complex) visibility, never changed
; ow: visibility weight
; uc: u-coordinate
; vc: v-coordinate
; cv: corrected visibility, initially copy of ov, then phase calibrated
; mv: model visibility
; si: scan index
; bi: baseline index, e.g. 12, 56, no more than 9 stations
; ci: channel index
; wl: wavelength [nm]
; bw: bandwidth [nm]
; fl: total flux = SED, read from scans.photometryc
; db: dirty beam, cube
; cb: clean beam, not a cube
; dm: dirty map, not a cube
; rm: residual map, not a cube
; cm: clean map, not a cube, accumulates all cc
; cc: clean components corresponding to one run of CLEAN, not a cube
; rt: temperature map
; rg: log(g) map
; rf: stellar atmosphere flux normalized by observed SED
;
; ob: OB index with same length as ov
; bl: Baseline index (1000*m+n) of station IDs m and n
;
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Tables,scantable,bgtable,stationtable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PearlBaselines,ob,bl
common LocalPearl,star,pearl_channel
;
if n_elements(lmin) eq 0 then lmin=100.		; [nm]
if n_elements(lmax) eq 0 then lmax=100000.	; [nm]
flag=0
if lmin lt 100 then flag=1
if lmax lt 100 then flag=1
if flag then begin
	print,'Error: lmin and lmax should be in [nm]!'
	return
endif
lmin=float(lmin)
lmax=float(lmax)
if lmax lt lmin then begin
	lmin=lmin-lmax/2
	lmax=lmin+lmax
endif
;
if n_elements(starid) eq 0 then begin
	ustars=unique(scans.starid)
	if n_elements(ustars) eq 1 then begin
		starid=ustars[0]
	endif else begin
        	print,'***Error(PEARLDATA): you have to specify a star!'
		status=-1
        	return
	endelse
endif
star=strupcase(starid)
;
for night=0,n_elements(bufferinfo)-1 > 0 do begin
if n_elements(bufferinfo) gt 1 then $
loadnight,GenInfo[night[0]].date, $
	  GeoInfo[night[0]].systemid, $
	  GenInfo[night[0]].configid
if night eq 0 then stationids=genconfig.stationid[0:genconfig.numsid-1] $
	      else stationids=[stationids, $
			      genconfig.stationid[0:genconfig.numsid-1]]
endfor
if n_elements(bufferinfo) gt 1 then $
stationids=unique(stationids)
;
nsi=0	; scan counter
;
FOR night=0,n_elements(bufferinfo)-1 > 0 DO BEGIN
;
nci=1	; channel counter
;
if n_elements(bufferinfo) gt 1 then $
loadnight,GenInfo[night[0]].date, $
	  GeoInfo[night[0]].systemid, $
	  GenInfo[night[0]].configid
;
index=where(scans.starid eq star and scantable.code eq 1,count)
if count eq 0 then begin
        print,'***Error(PEARLDATA): no scans on this star for this date!'
	status=-1
        return
endif
;
; These are reformed into flat arrays
ov=reform(scans[index].complexvis,n_elements(scans[index].complexvis))
ow=reform(scans[index].complexweight,n_elements(scans[index].complexweight))
uc=reform(scans[index].uvw(*,*,*,0),n_elements(scans[index].uvw(*,*,*,0)))
vc=reform(scans[index].uvw(*,*,*,1),n_elements(scans[index].uvw(*,*,*,1)))
ow[*]=1
;
; Create scan index, has same dimensions as ov, i.e. si(ob,ch,bl,sc)
; si=fix(scans(index).complexvis < 10) ; Removed 2020, may produce underflow
si=fix(scans[index].complexvis)
for i=0,count-1 do si[*,*,*,i]=i+1+nsi
si=reform(si,n_elements(si))
nsi=nsi+count
;
; Create baseline index, has same dimensions as ov, i.e. bi(ob,ch,bl,sc)
baselineid=intarr(genconfig.numoutbeam,max(genconfig.numbaseline))
ob_index=baselineid
bl_index=baselineid
for i=0,genconfig.numoutbeam-1 do begin
for l=0,genconfig.numbaseline[i]-1 do begin
        m=where(stationids eq strmid(genconfig.baselineid[l,i],0,3))+1
        n=where(stationids eq strmid(genconfig.baselineid[l,i],4,3))+1
        baselineid[i,l]=1000*m+n
	ob_index[i,l]=i
	bl_index[i,l]=l
endfor
endfor
; bi=fix(scans(index).complexvis < 10) ; Removed 2020, may produce underflow
bi=fix(scans[index].complexvis)
ob=bi
bl=bi
for j=0,max(genconfig.numspecchan)-1 do begin
	for i=0,count-1 do bi[*,j,*,i]=baselineid
	for i=0,count-1 do ob[*,j,*,i]=ob_index
	for i=0,count-1 do bl[*,j,*,i]=bl_index
endfor
bi=reform(bi,n_elements(bi))
ob=reform(ob,n_elements(ob))
bl=reform(bl,n_elements(bl))
;
; Create channel index, has same dimensions as ov, i.e. ci(ob,ch,bl,sc)
; ci=fix(scans(index).complexvis < 10) ; Removed 2020, may produce underflow
ci=fix(scans[index].complexvis)+1
;
; Not all scans have photometry computed
ti=3
if n_elements(size(scans[index].photometryc(0,0,*),/dim)) eq 2 then ti=2
fi=where(total(scans[index].photometryc(0,0,*),ti) gt 0)
spectrometers=strarr(genconfig.numoutbeam)
w=genconfig.wavelength	; save wavelength info
if system_id(systemid) eq 'NPOI' then begin
; 	Assume same channel layout for NPOI!
	mean_w=total(w,2)/genconfig.numoutbeam
	for i=0,genconfig.numoutbeam-1 do genconfig.wavelength[*,i]=mean_w
endif
for i=0,genconfig.numoutbeam-1 do $
	spectrometers[i]=strjoin(string( $
		genconfig.wavelength[0:genconfig.numspecchan[i]-1,i]*1e6))
uspms=unique(spectrometers)
;
for i=0L,n_elements(uspms)-1 do begin
	k=where(spectrometers eq uspms[i]) ; k=output beam index
	wl=genconfig.wavelength[0:genconfig.numspecchan[i]-1,k[0]]*1e9
	bw=genconfig.chanwidth[0:genconfig.numspecchan[i]-1,k[0]]*1e9
;	Get (calibrated) SED from telescope photometry
	fl=reform( $
	    scans[index[fi[0]]].photometryc(0,k,0:genconfig.numspecchan[i]-1))
	for j=1,genconfig.numsid-1 do fl=fl+reform( $
	    scans[index[fi[0]]].photometryc(j,k,0:genconfig.numspecchan[i]-1))
;	Smooth the SED (needs more work here!)
	n_sample=max([genconfig.numspecchan[i]/200,1])
	if n_sample gt 1 then fl=median(fl,n_sample)
;	Make sure the SED is not identical to zero
	if total(fl) eq 0 then fl=blackbody(5000.,wl*1e-9)
	if i eq 0 then wl0=wl else wl0=[wl0,wl]
	if i eq 0 then bw0=bw else bw0=[bw0,bw]
	if i eq 0 then fl0=fl else fl0=[fl0,fl]
;	Channel 0 reserved for white light: for-loop starts with j=1
	for j=0L,genconfig.numspecchan[i]-1 do ci[k,j,*,*]=j+nci
	nci=nci+genconfig.numspecchan[i]
endfor
genconfig.wavelength=w
ci=reform(ci,n_elements(ci))
;
; Select only data within requested wavelength range
jndex=where(wl lt lmin or wl gt lmax,count)
if count gt 0 then begin
 	index=whereequal(ci-1,jndex)
	ow[index]=0
endif
;
; Edit the uv-coverage
index=where(ow gt 0,count)
if count eq 0 then begin
        print,'***Error(PEARLDATA): no data for this star!'
	status=-1
        return
endif
ov=ov[index]
ow=ow[index]
uc=float(uc[index])
vc=float(vc[index])
si=si[index]
bi=bi[index]
ci=ci[index]
ob=ob[index]
bl=bl[index]
;
if night eq 0 then begin
	ov_all=ov
	ow_all=ow
	uc_all=uc
	vc_all=vc
	si_all=si
	bi_all=bi
	ci_all=ci
	ob_all=ob
	bl_all=bl
	wl_all=wl0
	bw_all=bw0
	fl_all=fl0
endif else begin
	ov_all=[ov_all,ov]
	ow_all=[ow_all,ow]
	uc_all=[uc_all,uc]
	vc_all=[vc_all,vc]
	si_all=[si_all,si]
	bi_all=[bi_all,bi]
	ci_all=[ci_all,ci]
	ob_all=[ob_all,ob]
	bl_all=[bl_all,bl]
	if n_elements(unique([wl_all,wl0])) ne n_elements(wl0) then begin
	print,'Warning: spectrometer wavelength differ [nm]: ', $
		max(abs(wl0-wl_all))
	endif
;	The following 3 lines are commented as the setups should be the same
;	wl_all=[wl_all,wl0]
;	bw_all=[bw_all,bw0]
;	fl_all=[bw_all,fl0]
endelse
;
ENDFOR
;
ov=ov_all
ow=ow_all
uc=uc_all
vc=vc_all
si=si_all
bi=bi_all
ci=ci_all
ob=ob_all
bl=bl_all
;
wl=wl_all
fl=fl_all
bw=bw_all
;
cv=ov
mv=ov*0
;
; We need to remove channel indices without data
scan_index=unique(si)
scan_count=n_elements(scan_index)
for i=1,scan_count do begin
	index=where(si eq i)
	uci=unique(ci)
	while n_elements(uci) lt max(uci) do begin
	for j=1,n_elements(uci) do begin
		if uci[j-1] gt j then begin
			index=indgen(n_elements(wl))+1
			k=where(index ne j)
			wl=wl[k]
			fl=fl[k]
			bw=bw[k]
			k=where(ci gt j)
			ci[k]=ci[k]-1
			uci=unique(ci)
			break
		endif
	endfor
	endwhile
endfor
;
wl=wl[0:max(uci)-1]
fl=fl[0:max(uci)-1]
bw=bw[0:max(uci)-1]
;
status=0
if max(abs(ov)) eq 0 then begin
        print,'***Error(PEARLDATA): no visibility data!'
	print,'(Did you not run set_complexvis before?)'
	status=-1
        return
endif
;
end
