function pearlflux,teff,clambda,dlambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Average blackbody flux over rectangular band pass
; defined through center wavelength clambda [nm] and full width dlambda [nm].
;
n=n_elements(clambda)
flux=fltarr(n)
i=where(dlambda le 1,count)
if count gt 0 then flux[i]=blackbody(teff,clambda[i]*1e-9)
i=where(dlambda gt 1,count)
for j=0,count-1 do begin
	l=(findgen(nint(dlambda[i[j]]))+clambda[i[j]]-dlambda[i[j]]/2)*1e-9
	flux[i[j]]=avg(blackbody(teff,l))
endfor
;
return,flux
;
end
