function pearlimage,imsze,cellsze,nc,relax=relax
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return an image of dimension imsize(0)*imsize(1)*nc, i.e. column by row,
; width by height, and cellsize in mas. The image coordinates x and y
; are measured in radians, and x increases to the left (east) just as
; the right ascension does.
;
; Both dimensions must be odd numbers, so that there will be a pixel on the
; center of the image. The bottom left corner is at pixel (0,0), the top right
; corner is (imsize(0)-1,imsize(1)-1)
;
; This is the special PEARL image format including effective temperatures.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
MAS2RAD=pi_circle/(180l*3600000l)
;
if n_elements(relax) eq 0 then relax=0
if n_elements(imsze) eq 1 then imsze=[imsze,imsze]
;
if not relax then begin
if imsze[0] mod 2 ne 1 then begin
        print,'***Error(SET_MAP): imsize[0] must be odd number!'
        return,-1
endif
if imsze[1] mod 2 ne 1 then begin
        print,'***Error(SET_MAP): imsize[1] must be odd number!'
        return,-1
endif
endif
if n_elements(nc) eq 0 then nc=1
;
imsize=long(imsze)
cellsize=float(cellsze*MAS2RAD)
;
maps=replicate({map:fltarr(imsize[0],imsize[1])},nc)	; data cube
teff=fltarr(imsize[0],imsize[1])
logg=fltarr(imsize[0],imsize[1])
x=(lindgen(imsize[0]*imsize[1]) mod imsize[0]) - (imsize[0]/2)
y=(lindgen(imsize[0]*imsize[1]) / imsize[0]) - (imsize[1]/2)
x=-x*cellsize	; RA increases to the left (East)
y=+y*cellsize
;
return,{maps:maps,teff:teff,logg:logg,x:x,y:y, $
	zero:fltarr(nc),scale:fltarr(nc)+1.0}
;
end
